package com.bizvane.customized.facade.interfaces;


import com.bizvane.customized.facade.models.vo.ur.notice.NoticeMemberLevelChangeReqVo;
import com.bizvane.customized.facade.models.vo.ur.notice.NoticeRechargeCardChangeRspVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.customized.name}", path = "${feign.client.customized.path}/ur/notice")
@Api(tags = {"UR通知接口"}, description = "与UR交互接口")
public interface URNoticeServiceFeign {


    /**
     * 会员等级变动
     */
    @PostMapping(value = "/memberLevelChange")
    ResponseData<NoticeRechargeCardChangeRspVo> memberLevelChange(@RequestBody @Valid NoticeMemberLevelChangeReqVo reqVo);

}
