package com.bizvane.customized.facade.interfaces;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.customized.facade.models.vo.CusUrIntegralUseCodeVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author dingShiChen
 * @since 2019/6/19
 */
@FeignClient(value="${feign.client.customized.name}",path="${feign.client.customized.path}/ur/integralUseCodeRpc")
@Api(value = "校验积分使用码",tags = {"积分使用码"})
public interface IntegralUseCodeServiceFeign {

	@ApiOperation(value = "校验积分使用码", notes = "给open-api调用")
	@PostMapping("/checkCode")
	ResponseData checkCode(@RequestBody CusUrIntegralUseCodeVO vo);

	@ApiOperation(value = "获取生成新的积分使用码", notes = "UR公众号、小程序使用此功能")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "offCardNo", value = "线下卡号", required = true, example = "UR1231512"),
	})
	@PostMapping("/addNewCode")
	ResponseData addNewCode(@RequestBody JSONObject params);
}
