package com.bizvane.customized.facade.utils;

import cn.hutool.core.bean.BeanUtil;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

/**
 * 集合copy简单工具
 */
public class ListCopyUtil {

    /**
     * 带回调函数的集合数据的拷贝（可自定义字段拷贝规则）
     * @param sources:  数据源类
     * @param target:   目标类::new(eg: UserVO::new)
     */
    public static <S, T> List<T> copyListProperties(List<S> sources, Supplier<T> target) {
        if (CollectionUtils.isEmpty(sources)){
            return new ArrayList<>();
        }
        List<T> list = new ArrayList<>(sources.size());
        for (S source : sources) {
            T t = target.get();
            BeanUtil.copyProperties(source, t);
            list.add(t);
        }
        return list;
    }

    /**
     * 带回调函数的集合数据的拷贝（可自定义字段拷贝规则）
     * @param sources:  数据源类
     * @param target:   目标类::new(eg: UserVO::new)
     */
    public static <S, T> Set<T> copyListPropertiesToSet(List<S> sources, Supplier<T> target) {
        if (CollectionUtils.isEmpty(sources)){
            return new HashSet<>();
        }
        Set<T> set = new HashSet<>(sources.size());
        for (S source : sources) {
            T t = target.get();
            BeanUtil.copyProperties(source, t);
            set.add(t);
        }
        return set;
    }

}
