package com.bizvane.customized.facade.utils;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.net.ssl.SSLContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;

@Slf4j
@Component
public class OkHttpUtils {

    public String getRequest(String url) throws IOException {
        log.info("请求信息url---->{}",url);
        OkHttpClient client = new OkHttpClient().newBuilder()
                .build();
        Request request = new Request.Builder()
                .url(url)
                .method("GET", null)
                .addHeader("Cookie", "PHPSESSID=d2a5a9a779916e0053ff3520c6763759")
                .build();
        Response response = client.newCall(request).execute();
        String result = null;
        if(response != null){
            if(response.body() != null){
                result = new String(response.body().bytes());
                response.body().close();
            }
            response.close();
        }
        log.info("result---->{}",result);
        return result;
    }

    /**
     * get请求
     * @param url 路径
     * @param params 参数
     * @param flag 路径是否带参
     * @return
     */
    public JSONObject httpGet(String url, Map<String, String> params, boolean flag) {
        OkHttpClient okHttpClient = new OkHttpClient();
        StringBuilder paramsStr = new StringBuilder();
        //处理参数
        if (!CollectionUtils.isEmpty(params)) {
            params.keySet().forEach(res -> {
                if (StringUtils.isNotBlank(paramsStr) || flag) {
                    paramsStr.append("&");
                } else {
                    paramsStr.append("?");
                }
                try {
                    paramsStr.append(String.format("%s=%s", res, URLEncoder.encode(params.get(res), "UTF-8")));
                } catch (UnsupportedEncodingException unsupportedEncodingException) {
                    log.info("httpGet method(),unsupportedEncodingException:{}", ExceptionUtils.getStackTrace(unsupportedEncodingException));
                }
            });
        }
        // 拼接参数
        String requestUrl = url + paramsStr;
        log.info("httpGet method(),requestUrl:{}", requestUrl);
        // 发送请求
        Request request = new Request.Builder()
                .url(requestUrl)
                .get()
                .addHeader("accept", "application/json; charset=utf-8")
                .build();
        try {
            Response response = okHttpClient.newCall(request).execute();
            String resultStr = response.body().string();
            response.close();
            log.info("httpGet jsonObjectResult:{}",resultStr);
            JSONObject jsonObjectResult = JSONObject.parseObject(resultStr);
            log.info("httpGet jsonObjectResult:{}",jsonObjectResult.toJSONString());
            return jsonObjectResult;
        } catch (Exception exception) {
            log.info("httpGet method(),exception:{}", ExceptionUtils.getStackTrace(exception));
            return null;
        }
    }

    /**
     * http POST 请求(收钱吧)
     * @param  url:请求地址
     * @param  body: body实体字符串
     * @param  sign:签名
     * @param  sn: 序列号
     * @return
     */
    public static String httpPost(String url, String body, String sign, String sn) {
        String xmlRes = "{}";
        HttpClient client = createSSLClientDefault();
        HttpPost httpPost = new HttpPost(url);
        try {
            log.debug("Request string: " + body);

            //所有请求的body都需采用UTF-8编码
            StringEntity entity = new StringEntity(body,"UTF-8");//
            entity.setContentType("application/json");
            httpPost.setEntity(entity);

            //支付平台所有的API仅支持JSON格式的请求调用，HTTP请求头Content-Type设为application/json
            httpPost.addHeader("Content-Type","application/json");

            //支付平台所有的API调用都需要签名验证,签名首部: Authorization: sn + " " + sign
            httpPost.addHeader("Authorization",sn + " " + sign);
            HttpResponse response = client.execute(httpPost);

            //所有响应也采用UTF-8编码
            xmlRes = EntityUtils.toString(response.getEntity(), "UTF-8");
            log.debug("Response string: " + xmlRes);
        } catch (ClientProtocolException e) {
            log.error("", e);
        } catch (IOException e) {
            log.error("", e);
        }
        return xmlRes;
    }

    private static CloseableHttpClient createSSLClientDefault() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy() {
                //信任所有
                public boolean isTrusted(X509Certificate[] chain,
                                         String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
            return HttpClients.custom().setSSLSocketFactory(sslsf).build();
        }  catch (KeyManagementException e) {
            log.error("", e);
        } catch (NoSuchAlgorithmException e) {
            log.error("", e);
        } catch (KeyStoreException e) {
            log.error("", e);
        }
        return HttpClients.createDefault();
    }
}
