package com.bizvane.customized.facade.models.vo.skyworth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author yingl
 * @date 2019-10-30 15:48
 */

@Data
@ApiModel(value="创维order/submit接口参数salePayDetail对象",description="创维order/submit接口参数salePayDetail对象实体")
public class OrderSubmitSalePayDetailVO {

    @ApiModelProperty(name = "storeId", value = "门店id", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String storeId;

    @ApiModelProperty(name = "orderNo", value = "订单号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String orderNo;

    @ApiModelProperty(name = "payTypeID", value = "支付类型ID", example = "b9e4bc8ff04c4444", dataType = "Integer", required = true)
    @NotNull
    private Integer payTypeID;

    @ApiModelProperty(name = "payAmount", value = "支付金额", example = "b9e4bc8ff04c4444", dataType = "BigDecimal", required = true)
    @NotNull
    private BigDecimal payAmount;

    @ApiModelProperty(name = "payNumber", value = "微信-商户订单号 \\n 支付宝-商户订单号 \\n 优惠券-券号 \\n 储值卡-卡号 \\n 折扣券-券号 \\n 积分抵现-会员号 \\n 云闪付-商户订单号 \\n 现金-空 \\n 银行卡-空", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String payNumber;
}
