package com.bizvane.customized.facade.models.vo.skyworth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author yingl
 * @date 2019-10-30 15:45
 */
@Data
@ApiModel(value="创维order/submit接口参数saleMaster对象",description="创维order/submit接口参数saleMaster对象实体")
public class OrderSubmitSaleMasterVO {

    @ApiModelProperty(name = "storeId", value = "门店id", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String storeId;

    @ApiModelProperty(name = "orderNo", value = "订单号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String orderNo;

    @ApiModelProperty(name = "orderTime", value = "订单时间（yyyy-MM-dd hh:mm:ss）", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String orderTime;

    @ApiModelProperty(name = "totalAmount", value = "订单总金额", example = "b9e4bc8ff04c4444", dataType = "BigDecimal", required = true)
    @NotNull
    private BigDecimal totalAmount;

    @ApiModelProperty(name = "totalQuantity", value = "商品总数量", example = "b9e4bc8ff04c4444", dataType = "Integer", required = true)
    @NotNull
    private Integer totalQuantity;

    @ApiModelProperty(name = "staffId", value = "收银员工号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String staffId;

    @ApiModelProperty(name = "cardNo", value = "会员卡号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String cardNo;

    @ApiModelProperty(name = "phone", value = "手机号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String phone;
}
