package com.bizvane.customized.facade.models.vo.skyworth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author yingl
 * @date 2019-10-30 15:45
 */
@Data
@ApiModel(value="创维order/submit接口参数saleDetail对象",description="创维order/submit接口参数saleDetail对象实体")
public class OrderSubmitSaleDetailVO {

    @ApiModelProperty(name = "storeId", value = "门店id", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String storeId;

    @ApiModelProperty(name = "orderNo", value = "订单号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String orderNo;

    @ApiModelProperty(name = "sequece", value = "序号", example = "b9e4bc8ff04c4444", dataType = "Integer", required = true)
    private Integer sequece;

    @ApiModelProperty(name = "materialCode", value = "商品款号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String materialCode;

    @ApiModelProperty(name = "colorNo", value = "色号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String colorNo;

    @ApiModelProperty(name = "size", value = "码数", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String size;

    @ApiModelProperty(name = "sku", value = "条码", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String sku;

    @ApiModelProperty(name = "quantity", value = "数量", example = "b9e4bc8ff04c4444", dataType = "Integer", required = true)
    @NotNull
    private Integer quantity;

    @ApiModelProperty(name = "price", value = "单价", example = "b9e4bc8ff04c4444", dataType = "BigDecimal", required = true)
    @NotNull
    private BigDecimal price;

    @ApiModelProperty(name = "amount", value = "售价", example = "b9e4bc8ff04c4444", dataType = "BigDecimal", required = true)
    @NotNull
    private BigDecimal amount;

    @ApiModelProperty(name = "specialPriceFlag", value = "正价(1:1  specialPriceFlag: 1或者 null 或者 \"\")  特价(10:1 specialPriceFlag: 2 )", example = "b9e4bc8ff04c4444", dataType = "BigDecimal", required = true)
    @NotNull
    private BigDecimal specialPriceFlag;
}
