package com.bizvane.customized.facade.models.vo.skyworth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author yingl
 * @date 2019-10-30 16:18
 */
@Data
@ApiModel(value = "创维order/syncStatus接口入参对象", description = "创维order/syncStatus接口入参对象实体")
public class CusSkyworthOrderSyncStatusRequestVO {

    @ApiModelProperty(name = "orderNo", value = "订单号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String orderNo;

    @ApiModelProperty(name = "orderStatus", value = "订单状态 1:待付款,2:待发货,3:待收货,4:待评价,5:已取消,6:已全退,7:退款中,8:已评价,9:退货中", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    private String orderStatus;

    @ApiModelProperty(name = "logisticsNo", value = "物流单号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String logisticsNo;

    @ApiModelProperty(name = "sendTime", value = "发货时间", example = "b9e4bc8ff04c4444", dataType = "Date", required = true)
    private Date sendTime;
}
