package com.bizvane.customized.facade.models.vo.skyworth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author yingl
 * @date 2019-10-30 16:25
 */
@Data
@ApiModel(value="创维order/list接口出参对象",description="创维order/list接口出参对象实体")
public class CusSkyworthOrderListResponseVO {

    @ApiModelProperty(name = "id", value = "订单id", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String id;

    @ApiModelProperty(name = "orderNo", value = "交易单号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String orderNo;

    @ApiModelProperty(name = "productId", value = "款号id", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String productId;

    @ApiModelProperty(name = "skuId", value = "条码id", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String skuId;

    @ApiModelProperty(name = "storeId", value = "店铺id", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String storeId;

    @ApiModelProperty(name = "empId", value = "员工id", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String empId;

    @ApiModelProperty(name = "orderStatus", value = "订单状态 1:待付款,2:待发货,3:待收货,4:待评价,5:已取消,6:已全退,7:退   款中,8:已评价,9:退货中", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String orderStatus;

    @ApiModelProperty(name = "orderSource", value = "订单来源", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String orderSource;

    @ApiModelProperty(name = "cardNo", value = "会员卡号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String cardNo;

    @ApiModelProperty(name = "commodityAmount", value = "商品金额  成交总额", example = "b9e4bc8ff04c4444", dataType = "BigDecimal", required = true)
    private BigDecimal commodityAmount;

    @ApiModelProperty(name = "tradeamount", value = "成交金额(优惠卷+抵扣卷+打折)", example = "b9e4bc8ff04c4444", dataType = "BigDecimal", required = true)
    private BigDecimal tradeamount;

    @ApiModelProperty(name = "totalQuantity", value = "件数(可以正负)", example = "b9e4bc8ff04c4444", dataType = "Integer", required = true)
    private Integer totalQuantity;

    @ApiModelProperty(name = "orderType", value = "订单类型", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String orderType;
}
