package com.bizvane.customized.facade.models.vo.skyworth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author yingl
 * @date 2019-10-30 16:21
 */
@Data
@ApiModel(value="创维order/list接口入参对象",description="创维order/list接口入参对象实体")
public class CusSkyworthOrderListRequestVO {

    @ApiModelProperty(name = "cardNo", value = "线下卡号", example = "1234567890", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "线下卡号不能为null")
    private String cardNo;

    @ApiModelProperty(name = "pageNumber", value = "查询页码", example = "1", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "查询页码不能为null")
    private String pageNumber;

    @ApiModelProperty(name = "pageSize", value = "查询页码大小（小于等于500）", example = "50", dataType = "Integer", required = true)
    @NotNull
    @Max(500)
    private Integer pageSize;

    @ApiModelProperty(name = "type", value = "类型 （消费/赠送）", example = "", dataType = "String", required = true)
    private String type;
}
