package com.bizvane.customized.facade.models.vo.skyworth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author yingl
 * @date 2019-10-30 11:50
 */
@Data
@ApiModel(value="创维member/prodile接口出参对象",description="创维member/prodile接口出参对象实体")
public class CusSkyworthMemberProfileResponseVO {

    @ApiModelProperty(name = "memberCode", value = "会员code", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String memberCode;

    @ApiModelProperty(name = "name", value = "姓名", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String name;

    @ApiModelProperty(name = "gender", value = "会员性别,女:1 男:2 未知:3", example = "1", dataType = "String", required = true)
    private String gender;

    @ApiModelProperty(name = "phone", value = "会员手机号", example = "11111111111", dataType = "String", required = true)
    private String phone;

    @ApiModelProperty(name = "empId", value = "所属导购", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String empId;

    @ApiModelProperty(name = "storeId", value = "所属门店", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String storeId;

    @ApiModelProperty(name = "cardTypeCode", value = "卡类型编号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String cardTypeCode;

    @ApiModelProperty(name = "cardNo", value = "卡号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String cardNo;

    @ApiModelProperty(name = "openId", value = "微信OPENID", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String openId;

    @ApiModelProperty(name = "openStatus", value = "开卡状态", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String openStatus;

    @ApiModelProperty(name = "integral", value = "总积分", example = "785", dataType = "Integer", required = true)
    private Integer integral;

    @ApiModelProperty(name = "birthday", value = "生日(年与日)", example = "2019-11-11 00:00:00", dataType = "Date", required = true)
    private Date birthday;

    @ApiModelProperty(name = "valid", value = "是否有效", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private Boolean valid;

    @ApiModelProperty(name = "modifiedDate", value = "记录最后更新时间", example = "2019-11-11 00:00:00", dataType = "Date", required = true)
    private Date modifiedDate;

    @ApiModelProperty(name = "createDate", value = "记录写入时间", example = "2019-11-11 00:00:00", dataType = "Date", required = true)
    private Date createDate;

    @ApiModelProperty(name = "province", value = "省份", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String province;

    @ApiModelProperty(name = "city", value = "城市", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String city;

    @ApiModelProperty(name = "county", value = "区/县", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String county;

    @ApiModelProperty(name = "address", value = "详细地址", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String address;
}
