package com.bizvane.customized.facade.models.vo.skyworth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author yingl
 * @date 2019-10-30 11:24
 */
@Data
@ApiModel(value="创维member/opencard接口入参对象",description="创维member/opencard接口入参对象实体")
public class CusSkyworthMemberOpenCardRequestVO {

    @ApiModelProperty(name = "phone", value = "手机号", example = "13686822222", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "phone请不要传空")
    private String phone;

    @ApiModelProperty(name = "cardNo", value = "卡号(默认手机号)", example = "13686822222", dataType = "String")
    private String cardNo;

    @ApiModelProperty(name = "name", value = "姓名", example = "名字", dataType = "String")
    private String name;

    @ApiModelProperty(name = "gender", value = "会员性别,女:1 男:2 未知:3", example = "1", dataType = "String")
    private String gender;

    @ApiModelProperty(name = "birthday", value = "生日(yyyy-mm-dd)", example = "1996-09-12", dataType = "String")
    private String birthday;

    @ApiModelProperty(name = "wxOpenID", value = "微信", example = "b9e4bc8ff04c4444", dataType = "String")
    private String wxOpenID;

    @ApiModelProperty(name = "storeId", value = "注册门店", example = "b9e4bc8ff04c4444", dataType = "String")
    private String storeId;

    @ApiModelProperty(name = "registerType", value = "注册平台code（1官网，2优品，3酷开，4智家，5爱内购）", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "registerType请不要传空")
    private String platformCode;

    @ApiModelProperty(name = "staffId", value = "员工id", example = "b9e4bc8ff04c4444", dataType = "String")
    private String staffId;

    @ApiModelProperty(name = "cardTypeCode", value = "卡类型code（卡等级/类型编号）", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "cardTypeCode请不要传空")
    private String cardTypeCode;
}
