package com.bizvane.customized.facade.models.vo.skyworth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.Date;

/**
 * @author yingl
 * @date 2019-10-30 15:24
 */
@Data
@ApiModel(value="创维member/modify接口入参对象",description="创维member/modify接口入参对象实体")
public class CusSkyworthMemberModifyRequestVO {

    @ApiModelProperty(name = "phone", value = "手机号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String phone;

    @NotNull
    @Size(min = 1,message = "请不要传空")
    @ApiModelProperty(name = "cardNo", value = "会员卡号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String cardNo;

    @ApiModelProperty(name = "name", value = "姓名", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String name;

    @ApiModelProperty(name = "gender", value = "性别", example = "1", dataType = "Integer", required = true)
    private String gender;

    @ApiModelProperty(name = "wxOpenID", value = "微信", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String wxOpenID;

    @ApiModelProperty(name = "province", value = "省份", example = "广东", dataType = "String", required = true)
    private String province;

    @ApiModelProperty(name = "city", value = "城市", example = "广州", dataType = "String", required = true)
    private String city;

    @ApiModelProperty(name = "county", value = "区/县", example = "番禺", dataType = "String", required = true)
    private String county;

    @ApiModelProperty(name = "birthday", value = "生日", example = "1995-11-01 00:00:00", dataType = "String", required = true)
    private String birthday;
}
