package com.bizvane.customized.facade.models.vo.skyworth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author gp.n
 * @date 2019-11-12 17:21
 */
@Data
@ApiModel(value="创维integral/detil接口入参对象",description="创维integral/detil接口入参对象实体")
public class CusSkyworthIntegralDetailRequestVO {
    @ApiModelProperty(name = "cardNo", value = "会员卡号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "cardNo请不要传空")
    private String cardNo;

    @ApiModelProperty(name = "startTime", value = "开始时间", example = "0000-00-00 00:00:00", dataType = "Date", required = true)
    private Date startTime;

    @ApiModelProperty(name = "endTime", value = "结束时间", example = "0000-00-00 00:00:00", dataType = "Date", required = true)
    private Date endTime;

    @ApiModelProperty(name = "integralType", value = "积分类型（1 赠送 2 消费 3退货  4 积分调整减积分  5 积分调整增积分  6 积分兑换　7 积分抵现  8积分抵现返还 9 积分清零 10 赠送退回）", example = "1", dataType = "String", required = true)
    private String integralType;


    @ApiModelProperty(name = "pageNumber", value = "查询页码", example = "5", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "pageNumber请不要传空")
    private String pageNumber;

    @ApiModelProperty(name = "pageSize", value = "查询页码大小（小于等于500）", example = "1", dataType = "Integer", required = true)
    @NotNull
    @Max(500)
    private Integer pageSize;


}
