package com.bizvane.customized.facade.models.vo.skyworth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;


import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author yingl
 * @date 2019-10-30 15:29
 */
@Data
@ApiModel(value="创维integral/adjust接口入参对象",description="创维integral/adjust接口入参对象实体")
public class CusSkyworthIntegralAdjustRequestVO {

    @ApiModelProperty(name = "cardNo", value = "会员卡号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @Size(min = 1,message = "cardNo请勿传空")
    @NotNull
    private String cardNo;

    @ApiModelProperty(name = "integralType", value = "积分类型（1 赠送 2 消费 3退货  4 积分调整减积分  5 积分调整增积分  6 积分兑换　7 积分抵现  8积分抵现返还 9 积分清零 10 赠送退回）", example = "1", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "integralType请勿传空")
    private String integralType;

    @ApiModelProperty(name = "changeBillNo", value = "变更订单号", example = "6454x1e", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "changeBillNo请勿传空")
    private String changeBillNo;

    @ApiModelProperty(name = "phone", value = "手机号", example = "11111111111", dataType = "String", required = true)
    private String phone;

    @ApiModelProperty(name = "changeIntegral", value = "变更积分(正负)", example = "-1", dataType = "BigDecimal", required = true)
    @NotNull(message = "changeIntegral请勿传空")
    private BigDecimal changeIntegral;

    @ApiModelProperty(name = "changeDate", value = "单据日期", example = "2019-11-01 00:00:00", dataType = "Date", required = true)
    @NotNull
    private Date changeDate;

    @ApiModelProperty(name = "description", value = "描述", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String description;

    @ApiModelProperty(name = "integralTypeName", value = "积分类别名称", example = "1", dataType = "String", required = true)
    @Size(min=1,message = "integralTypeName请勿传空")
    @NotNull
    private String integralTypeName;

    @ApiModelProperty(name = "storeId", value = "门店ID", example = "123456", dataType = "String", required = true)
    private String storeId;


    @ApiModelProperty(name = "platformCode", value = "平台ID", example = "123456", dataType = "String", required = true)
    private String platformCode;
}
