package com.bizvane.customized.facade.models.vo.skyworth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author yingl
 * @date 2019-10-30 16:40
 */

@Data
@ApiModel(value="创维coupon/use接口入参对象",description="创维coupon/use接口入参对象实体")
public class CusSkyworthCouponUseRequestVO {

    @ApiModelProperty(name = "couponCode", value = "优惠券号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull(message = "优惠券号不能为空")
    @Size(min = 1,message = "优惠券号不能为空")
    private String couponCode;

    @ApiModelProperty(name = "storeId", value = "线下核销门店编号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String storeId;

    @ApiModelProperty(name = "usetime", value = "使用时间", example = "b9e4bc8ff04c4444", dataType = "Date", required = true)
    @NotNull(message = "使用时间为空或时间格式错误")
    private Date usetime;

    @ApiModelProperty(name = "useBusinessCode", value = "线下零售单号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String useBusinessCode;

    @ApiModelProperty(name = "amount", value = "核销金额", example = "b9e4bc8ff04c4444", dataType = "BigDecimal", required = true)
    private BigDecimal amount;
}
