package com.bizvane.customized.facade.models.vo.skyworth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author yingl
 * @date 2019-10-30 16:43aa
 */
@Data
@ApiModel(value="创维coupon/transfer接口入参对象",description="创维coupon/transfer接口入参对象实体")
public class CusSkyworthCouponTransferRequestVO {

    @ApiModelProperty(name = "couponCode", value = "优惠券号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "优惠券号不能为null")
    private String couponCode;

    @ApiModelProperty(name = "cardNo", value = "转增目标会员卡号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "转增目标会员卡号不能为null")
    private String cardNo;

    @ApiModelProperty(name = "transferCardNo", value = "原持有会员卡号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "原持有会员卡号不能为null")
    private String transferCardNo;

    @ApiModelProperty(name = "transferInfo", value = "转增说明", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String transferInfo;
}
