package com.bizvane.customized.facade.models.vo.skyworth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author yingl
 * @date 2019-10-30 16:32
 */
@Data
@ApiModel(value="创维coupon/list接口出参对象",description="创维coupon/list接口出参对象实体")
public class CusSkyworthCouponListResponseVO {

    @ApiModelProperty(name = "couponDefinitionCode", value = "券类型号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String couponDefinitionCode ;

    @ApiModelProperty(name = "couponName", value = "券名称", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String couponName ;

    @ApiModelProperty(name = "couponCode", value = "券号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String couponCode ;

    @ApiModelProperty(name = "validDateStart", value = "有效期开始", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String validDateStart ;

    @ApiModelProperty(name = "validDateEnd", value = "有效期结束", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String validDateEnd ;

    @ApiModelProperty(name = "cardNo", value = "会员卡号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String cardNo ;

    @ApiModelProperty(name = "money", value = "面额", example = "b9e4bc8ff04c4444", dataType = "BigDecimal", required = true)
    private BigDecimal money ;

    @ApiModelProperty(name = "discount", value = "折扣", example = "b9e4bc8ff04c4444", dataType = "BigDecimal", required = true)
    private BigDecimal discount;

    @ApiModelProperty(name = "platformCode", value = "券使用平台1官网，2优品，3酷开，4智家，5爱内购", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String platformCode;

    @ApiModelProperty(name = "isTransfer", value = "是否允许转赠", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private Integer isTransfer;

    @ApiModelProperty(name = "isSuperposition", value = "是否允许叠加", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private Integer isSuperposition;

    @ApiModelProperty(name = "minConsume", value = "最低消费金额", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private BigDecimal minConsume;

    @ApiModelProperty(name = "maxPreferential", value = "最高优惠金额", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private BigDecimal maxPreferential;
}
