package com.bizvane.customized.facade.models.vo.skyworth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author yingl
 * @date 2019-10-30 16:32
 */
@Data
@ApiModel(value="创维coupon/list接口入参对象",description="创维coupon/list接口入参对象实体")
public class CusSkyworthCouponListRequestVO {

    @ApiModelProperty(name = "cardNo", value = "会员卡号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "会员卡号不能为空")
    private String cardNo;

    @ApiModelProperty(name = "status", value = "状态（0未使用1使用2过期）", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    private String status;

    @ApiModelProperty(name = "pageNumber", value = "查询页码", example = "1", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "pageNumber请不要传空")
    private String pageNumber;

    @ApiModelProperty(name = "pageSize", value = "查询页码大小（小于等于500）", example = "5", dataType = "Integer", required = true)
    @NotNull
    @Max(500)
    private Integer pageSize;
}
