package com.bizvane.customized.facade.models.vo.skyworth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author yingl
 * @date 2019-10-30 16:46
 */
@Data
@ApiModel(value="创维behavior/save接口入参对象",description="创维behavior/save接口入参对象实体")
public class CusSkyworthBehaviorSaveRequestVO {

    @ApiModelProperty(name = "cardNo", value = "会员卡号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "cardNo请不要传空")
    private String cardNo;

    @ApiModelProperty(name = "browsePage", value = "浏览页面", example = "xxx.com", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "browsePage请不要传空")
    private String browsePage;

    @ApiModelProperty(name = "stayTime", value = "停留时长", example = "60", dataType = "Integer", required = true)
    @NotNull
    private Integer stayTime;

    @ApiModelProperty(name = "browseProductId", value = "浏览商品Id", example = "b9e4bc8ff04c4444", dataType = "Long", required = true)
    @NotNull
    private Long browseProductId;

    @ApiModelProperty(name = "browseProductName", value = "浏览商品名称", example = "奶粉", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "browseProductName请不要传空")
    private String browseProductName;

    @ApiModelProperty(name = "collectProductId", value = "收藏商品Id", example = "616161", dataType = "Long", required = true)
    @NotNull
    private Long collectProductId;




}
