package com.bizvane.customized.facade.models.vo.skyworth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.Date;

/**
 * @author yingl
 * @date 2019-10-30 16:51
 */
@Data
@ApiModel(value="创维behavior/list接口入参对象",description="创维behavior/list接口入参对象实体")
public class CusSkyworthBehaviorListRequestVO {

    @ApiModelProperty(name = "cardNo", value = "会员卡号", example = "b9e4bc8ff04c4444", dataType = "String", required = true)
    @NotNull
    @Size(min = 1,message = "cardNo请不要传空")
    private String cardNo;

    @ApiModelProperty(name = "browseProductId", value = "浏览商品Id", example = "123456", dataType = "Long", required = true)
    private Long browseProductId;

    @ApiModelProperty(name = "browseProductName", value = "浏览商品名称", example = "xx奶粉", dataType = "String", required = true)
    private String browseProductName;

    @ApiModelProperty(name = "stayTimeStart", value = "查询浏览时间起始", example = "2019-11-11 00:00:00", dataType = "Date", required = true)
    private Date stayTimeStart;


    @ApiModelProperty(name = "stayTimeEnd", value = "浏览时间终止", example = "2019-11-11 00:00:00", dataType = "Date", required = true)
    private Date stayTimeEnd;
}
