package com.bizvane.customized.facade.models.dto.skyworth;

import com.bizvane.customized.facade.enums.CardStatusEnum;
import com.bizvane.customized.facade.models.po.skyworth.CusSkyworthMbrMembers;
import com.bizvane.customized.facade.models.vo.skyworth.CusSkyworthMemberProfileRequestVO;
import com.bizvane.customized.facade.models.vo.skyworth.CusSkyworthMemberProfileResponseVO;
import lombok.extern.slf4j.Slf4j;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author yingl
 * @date 2019-11-05 14:45
 */
@Slf4j
public class CusSkyworthMbrMembersDTO extends AbstractConvert<CusSkyworthMbrMembers, CusSkyworthMemberProfileRequestVO,CusSkyworthMemberProfileResponseVO>  {


    @Override
    public CusSkyworthMemberProfileResponseVO convertVO(CusSkyworthMbrMembers cusSkyworthMbrMembers) {
        CusSkyworthMemberProfileResponseVO cusSkyworthMemberProfileResponseVO = new CusSkyworthMemberProfileResponseVO();
        cusSkyworthMemberProfileResponseVO.setMemberCode(cusSkyworthMbrMembers.getMemberCode());

        cusSkyworthMemberProfileResponseVO.setName(cusSkyworthMbrMembers.getName());
        cusSkyworthMemberProfileResponseVO.setGender(cusSkyworthMbrMembers.getGender());
        cusSkyworthMemberProfileResponseVO.setPhone(cusSkyworthMbrMembers.getPhone());
        cusSkyworthMemberProfileResponseVO.setEmpId(String.valueOf(cusSkyworthMbrMembers.getServiceGuideCode()));
        cusSkyworthMemberProfileResponseVO.setStoreId(cusSkyworthMbrMembers.getServiceStoreCode());

        cusSkyworthMemberProfileResponseVO.setCardTypeCode(cusSkyworthMbrMembers.getCardtypecode());
        cusSkyworthMemberProfileResponseVO.setCardNo(cusSkyworthMbrMembers.getCardNo());
        cusSkyworthMemberProfileResponseVO.setOpenId(cusSkyworthMbrMembers.getWxOpenId());

        String openCardStatus = "未绑定";
        if(CardStatusEnum.getCardStatusEnumByCode(cusSkyworthMbrMembers.getCardStatus())!=null){
            openCardStatus = CardStatusEnum.getCardStatusEnumByCode(cusSkyworthMbrMembers.getCardStatus()).getValue();
        }
        cusSkyworthMemberProfileResponseVO.setOpenStatus(openCardStatus);
       // cusSkyworthMemberProfileResponseVO.setIntegral(cusSkyworthMbrMembers.getCountIntegral());
        SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        try {
            cusSkyworthMemberProfileResponseVO.setBirthday(sdf.parse(cusSkyworthMbrMembers.getBirthday()));
        } catch (ParseException e) {
            log.info("日期转换出现错误");
            e.printStackTrace();
        }
        cusSkyworthMemberProfileResponseVO.setValid(cusSkyworthMbrMembers.getValid().equals(1));
        //cusSkyworthMemberProfileResponseVO.setModifiedDate(cusSkyworthMbrMembers.getModifiedDate());

       // cusSkyworthMemberProfileResponseVO.setCreateDate(cusSkyworthMbrMembers.getCreateDate());
        cusSkyworthMemberProfileResponseVO.setProvince(cusSkyworthMbrMembers.getProvince());
        cusSkyworthMemberProfileResponseVO.setCity(cusSkyworthMbrMembers.getCity());
        cusSkyworthMemberProfileResponseVO.setCounty(cusSkyworthMbrMembers.getCounty());
        cusSkyworthMemberProfileResponseVO.setAddress(cusSkyworthMbrMembers.getAddress());

        return cusSkyworthMemberProfileResponseVO;
    }

    @Override
    public CusSkyworthMbrMembers convertPO(CusSkyworthMemberProfileRequestVO request) {



        return null;
    }
}
