package com.bizvane.customized.facade.models.dto.skyworth;

import com.bizvane.customized.facade.models.po.skyworth.CusSkyworthCouponEntity;
import com.bizvane.customized.facade.models.vo.skyworth.CusSkyworthCouponListRequestVO;
import com.bizvane.customized.facade.models.vo.skyworth.CusSkyworthCouponListResponseVO;
import com.bizvane.utils.commonutils.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author yingl
 * @date 2019-11-07 11:06
 */
@Slf4j
public class CusSkyworthCouponEntityDTO extends AbstractConvert<CusSkyworthCouponEntity, CusSkyworthCouponListRequestVO, CusSkyworthCouponListResponseVO> implements ListCopy<CusSkyworthCouponEntity,CusSkyworthCouponListResponseVO>  {

    @Override
    public CusSkyworthCouponListResponseVO convertVO(CusSkyworthCouponEntity cusSkyworthCouponEntity) {
        CusSkyworthCouponListResponseVO cusSkyworthCouponListResponseVO = new CusSkyworthCouponListResponseVO();
        cusSkyworthCouponListResponseVO.setCouponDefinitionCode(cusSkyworthCouponEntity.getCouponDefinitionCode());
        cusSkyworthCouponListResponseVO.setCouponName(cusSkyworthCouponEntity.getCouponName());
        cusSkyworthCouponListResponseVO.setCouponCode(cusSkyworthCouponEntity.getCouponCode());
        //处理时间
        String dateStart = null,dateEnd = null;
        try{
            dateStart = DateUtils.dateFormatTime(cusSkyworthCouponEntity.getValidDateStart());
            dateEnd = DateUtils.dateFormatTime(cusSkyworthCouponEntity.getValidDateEnd());
        }catch(Exception e){
            log.info("CusSkyworthCouponEntityDTO 时间处理异常:{}",e.getStackTrace());
            e.printStackTrace();
        }
        cusSkyworthCouponListResponseVO.setValidDateStart(dateStart);
        cusSkyworthCouponListResponseVO.setValidDateEnd(dateEnd);
        cusSkyworthCouponListResponseVO.setCardNo(cusSkyworthCouponEntity.getCardNo());
        cusSkyworthCouponListResponseVO.setMoney(cusSkyworthCouponEntity.getMoney());
        cusSkyworthCouponListResponseVO.setDiscount(cusSkyworthCouponEntity.getDiscount());
        cusSkyworthCouponListResponseVO.setPlatformCode(cusSkyworthCouponEntity.getPlatformCode());
        cusSkyworthCouponListResponseVO.setIsTransfer(cusSkyworthCouponEntity.getIsTransfer());
        cusSkyworthCouponListResponseVO.setIsSuperposition(cusSkyworthCouponEntity.getIsSuperposition());
        cusSkyworthCouponListResponseVO.setMinConsume(cusSkyworthCouponEntity.getMinConsume());
        cusSkyworthCouponListResponseVO.setMaxPreferential(cusSkyworthCouponEntity.getMaxPreferential());
        return cusSkyworthCouponListResponseVO;
    }

    @Override
    public CusSkyworthCouponEntity convertPO(CusSkyworthCouponListRequestVO request) {
        return null;
    }


}
