package com.bizvane.customized.facade.models.dto.skyworth;

import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author yingl
 * @date 2019-11-05 14:46
 */
public abstract class AbstractConvert<entityPO,requestVO,responseVO> implements ListCopy<entityPO,responseVO> {

    public abstract responseVO convertVO(entityPO po);

    public abstract entityPO convertPO(requestVO request);

    @Override
    public List<responseVO> copyList(List<entityPO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<responseVO> responseVOS = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            responseVO responseVO = this.convertVO(list.get(i));
            responseVOS.add(responseVO);
        }
        return responseVOS;
    }
}
