package com.bizvane.customized.facade.enums;

import lombok.Getter;

/**
 * @author chen.li
 * @date on 2019/11/6 15:09
 * @description
 */
@Getter
public enum CardStatusEnum {

    /**
     * 开卡状态
     */
    CARD_STATUS_UNBIND(1,"未绑定"),
    CARD_STATUS_BINDED(2,"已绑定");

    private Integer code;
    private String value;

    CardStatusEnum(Integer code,String value){
        this.code = code;
        this.value = value;
    }

    /**
     * 获取code对应String描述
     * @return
     */
    public static CardStatusEnum getCardStatusEnumByCode(Integer code){
        for(CardStatusEnum activityStatusEnum : CardStatusEnum.values()){
            if(code.equals(activityStatusEnum.getCode())){
                return activityStatusEnum;
            }
        }
        return null;
    }
}
