package com.bizvane.customized.facade.models.vo.ur;

import lombok.Data;

/**
 * @author yuantq
 * @date 2022/1/12
 */
@Data
public class SqbInvoiceTicketModel {

    /**
     * 销货方税号
     */
    private String tax_register_no;

    /**
     * 发票ID
     */
    private String invoice_id;

    /**
     * 价税总和，单位元
     */
    private String invoice_amount;

    /**
     * 总税额，单位元
     */
    private String invoice_sum_tax;

    /**
     * 不含税总金额，单位元
     */
    private String invoice_sum_price;

    /**
     * 开票时间戳 13位毫秒级
     */
    private String invoice_time;

    /**
     * 发票状态，0：已出票，1：已红冲（蓝票才有）
     */
    private String invoice_status;

    /**
     * 发票类型0:蓝票 1:红票
     */
    private String invoice_type;

    /**
     * 发票code
     */
    private String invoice_code;

    /**
     * 发票no
     */
    private String invoice_no;

    /**
     * 邮件pdf,蓝票才会有该字段
     */
    private String invoice_file_path;

}
