package com.bizvane.customized.facade.models.po;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@ApiModel(value = "com.bizvane.customized.facade.models.po.CusMbrFrozenRecordPo")
@Data
public class CusMbrFrozenRecordPo implements Serializable {
    /**
     * 主键id
     */
    @ApiModelProperty(value = "主键id")
    private Long cusMbrFrozenRecordId;

    /**
     * 所属企业id
     */
    @ApiModelProperty(value = "所属企业id")
    private Long sysCompanyId;

    /**
     * 品牌id
     */
    @ApiModelProperty(value = "品牌id")
    private Long sysBrandId;

    /**
     * 会员code
     */
    @ApiModelProperty(value = "会员code")
    private String memberCode;

    /**
     * 会员卡号
     */
    @ApiModelProperty(value = "会员卡号")
    private String cardNo;

    /**
     * 线下会员id
     */
    @ApiModelProperty(value = "线下会员id")
    private String erpId;

    /**
     * 会员名称
     */
    @ApiModelProperty(value = "会员名称")
    private String name;

    /**
     * 会员手机号
     */
    @ApiModelProperty(value = "会员手机号")
    private String phone;

    /**
     * 服务店铺code
     */
    @ApiModelProperty(value = "服务店铺code")
    private String serviceStoreCode;

    /**
     * 服务店铺名称
     */
    @ApiModelProperty(value = "服务店铺名称")
    private String serviceStoreName;

    /**
     * 会员等级
     */
    @ApiModelProperty(value = "会员等级")
    private String levelCode;

    /**
     * 会员名称
     */
    @ApiModelProperty(value = "会员名称")
    private String levelName;

    /**
     * 冻结状态,1:冻结 2: 解冻
     */
    @ApiModelProperty(value = "冻结状态,1:冻结 2: 解冻")
    private Integer status;

    /**
     * 冻结流水号
     */
    @ApiModelProperty(value = "冻结流水号")
    private String frozenRecord;

    /**
     * 冻结类型,冻结配置表
     * 0全部
     * 1.会员卡档案冻结
     * 2.单周累计积分
     * 3.单周消费次数
     * 4.单周单区域累计积分
     * 5.单周单区域消费次数
     * 6.单月累计积分
     * 7.单月消费次数
     * 8.单月单区域累计积分
     * 9单月单区域消费次数
     */
    @ApiModelProperty(value = "冻结类型")
    private Integer frozenType;

    /**
     * 冻结详情
     */
    @ApiModelProperty(value = "冻结详情")
    private String frozenDetail;

    /**
     * 解冻原因 1:手工解冻 2:加入白名单
     */
    @ApiModelProperty(value = "解冻原因 1:手工解冻 2:加入白名单")
    private String frozenReason;

    /**
     * 是在存在白名单：1:否 2:是
     */
    @ApiModelProperty(value = "是在存在白名单：1:否 2:是")
    private Integer whiteList;

    /**
     * 冻结/解冻时间
     */
    @ApiModelProperty(value = "冻结时间")
    private Date frozenDate;

    /**
     * 冻结/解冻时间
     */
    @ApiModelProperty(value = "冻结时间")
    private Date thawDate;


    /**
     * 数据有效性：1=有效；0=无效
     */
    @ApiModelProperty(value = "数据有效性：1=有效；0=无效")
    private Boolean valid;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 创建人id
     */
    @ApiModelProperty(value = "创建人id")
    private Long createUserId;

    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createUserName;

    /**
     * 创建日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "Asia/Shanghai")
    @ApiModelProperty(value = "创建日期")
    private Date createDate;

    /**
     * 修改人id
     */
    @ApiModelProperty(value = "修改人id")
    private Long modifiedUserId;

    /**
     * 修改人
     */
    @ApiModelProperty(value = "修改人")
    private String modifiedUserName;

    /**
     * 修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "Asia/Shanghai")
    @ApiModelProperty(value = "修改时间")
    private Date modifiedDate;

    /**
     * 版本号
     */
    @ApiModelProperty(value = "版本号")
    private Integer version;

    private static final long serialVersionUID = 1L;
}