package com.bizvane.customized.facade.interfaces;

import com.bizvane.baisonBase.facade.models.mj.QueryGiftRecordsResponseVo;
import com.bizvane.customized.facade.models.vo.mj.CurMjGiftCardConfigVo;
import com.bizvane.customized.facade.models.vo.mj.CurMjGiftCardRecordRequestVo;
import com.bizvane.customized.facade.models.vo.mj.CusMjGiftCardRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value="${feign.client.customized.name}",path="${feign.client.customized.path}/mjGiftCardRpc")
@Api(value = "梦洁礼品卡相关接口",tags = {"梦洁礼品卡"})
public interface CurMjGiftCardServiceFegin {

    /**
     * 绑定礼品卡(小程序)  我的礼品卡配置
     * @param vo
     * @return
     */
    @RequestMapping(value = "bindGiftCard",method = RequestMethod.POST)
    ResponseData<String> bindGiftCard(@RequestBody CusMjGiftCardRequestVo vo);



    /**
     * 获取礼品卡配置(小程序)
     * @param vo
     * @return
     */
    @RequestMapping(value = "getGiftCardConfig",method = RequestMethod.POST)
    ResponseData<CurMjGiftCardConfigVo> getGiftCardConfig(@RequestBody CurMjGiftCardConfigVo vo);


    /**
     * 查询礼品卡流水(小程序)
     * @param vo
     * @return
     */
    @RequestMapping(value = "selectPage",method = RequestMethod.POST)
    ResponseData<PageInfo<QueryGiftRecordsResponseVo>> selectPage(@RequestBody CurMjGiftCardRecordRequestVo vo);


}
