package com.bizvane.customized.facade.models.vo.teddy;

import com.bizvane.customized.facade.enums.teddy.CusTeddyGoodsTaskStatusEnum;

import java.util.Date;

public class CusTeddyUtil {

    /**
     * 任务是否失败，分两种情况，其一、状态为2是失败，其二、超时也是失败
     * @param taskStatus 任务状态
     * @param taskExecuteTime 任务开始执行时间
     * @return
     */
    public static Boolean taskIsFail(Byte taskStatus, Date taskExecuteTime) {
        if (taskStatus == null || taskExecuteTime == null) {
            return false;
        }
        boolean isFail = ((byte) CusTeddyGoodsTaskStatusEnum.FAIL.getCode().intValue() == taskStatus);
        return isFail || taskIsTimeout(taskExecuteTime);
    }

    /**
     * 任务是否超时，超过2小时=失败
     * @param taskExecuteTime
     * @return
     */
    public static Boolean taskIsTimeout(Date taskExecuteTime) {
        if (taskExecuteTime == null) {
            return false;
        }
        long executeTime = taskExecuteTime.getTime();
        long currentTime = System.currentTimeMillis();
        long diff = (currentTime - executeTime) / 1000;
        boolean isTimeout = diff > (60 * 60 * 2);
        return isTimeout;
    }

}
