package com.bizvane.customized.facade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import javax.validation.constraints.NotNull;

/**
 * @author bizvane
 * @version 1.0.0
 * @ClassName CusUrReceiveTransferVo.java
 * @Description 转增领取vo
 * @createTime 2020年03月17日 14:01:00
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CusUrReceiveTransferVo {

    @NotNull
    @ApiModelProperty(value = "memberCode",name = "领取转增memberCode")
    private String memberCode;

    @NotNull
    @ApiModelProperty(value = "transferRecordId",name = "转增记录id")
    private Long transferRecordId;

    @ApiModelProperty(value = "receiveName",name = "受赠人微信昵称")
    private String receiveName;


    @ApiModelProperty(value = "sysCompanyId" , name = "企业id")
    @NotNull
    private Long sysCompanyId;

    @ApiModelProperty(value = "sysBrandId" , name = "品牌id")
    @NotNull
    private Long sysBrandId;

}
