package com.bizvane.customized.facade.utils;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

@Slf4j
@Component
public class OkHttpUtils {

    public String getRequest(String url) throws IOException {
        log.info("请求信息url---->{}",url);
        OkHttpClient client = new OkHttpClient().newBuilder()
                .build();
        Request request = new Request.Builder()
                .url(url)
                .method("GET", null)
                .addHeader("Cookie", "PHPSESSID=d2a5a9a779916e0053ff3520c6763759")
                .build();
        Response response = client.newCall(request).execute();
        String result = null;
        if(response != null){
            if(response.body() != null){
                result = new String(response.body().bytes());
                response.body().close();
            }
            response.close();
        }
        log.info("result---->{}",result);
        return result;
    }

    /**
     * get请求
     * @param url 路径
     * @param params 参数
     * @param flag 路径是否带参
     * @return
     */
    public JSONObject httpGet(String url, Map<String, String> params, boolean flag) {
        OkHttpClient okHttpClient = new OkHttpClient();
        StringBuilder paramsStr = new StringBuilder();
        //处理参数
        if (!CollectionUtils.isEmpty(params)) {
            params.keySet().forEach(res -> {
                if (StringUtils.isNotBlank(paramsStr) || flag) {
                    paramsStr.append("&");
                } else {
                    paramsStr.append("?");
                }
                try {
                    paramsStr.append(String.format("%s=%s", res, URLEncoder.encode(params.get(res), "UTF-8")));
                } catch (UnsupportedEncodingException unsupportedEncodingException) {
                    log.info("httpGet method(),unsupportedEncodingException:{}", ExceptionUtils.getStackTrace(unsupportedEncodingException));
                }
            });
        }
        // 拼接参数
        String requestUrl = url + paramsStr;
        log.info("httpGet method(),requestUrl:{}", requestUrl);
        // 发送请求
        Request request = new Request.Builder()
                .url(requestUrl)
                .get()
                .addHeader("accept", "application/json; charset=utf-8")
                .build();
        try {
            Response response = okHttpClient.newCall(request).execute();
            String resultStr = response.body().string();
            response.close();
            log.info("httpGet jsonObjectResult:{}",resultStr);
            JSONObject jsonObjectResult = JSONObject.parseObject(resultStr);
            log.info("httpGet jsonObjectResult:{}",jsonObjectResult.toJSONString());
            return jsonObjectResult;
        } catch (Exception exception) {
            log.info("httpGet method(),exception:{}", ExceptionUtils.getStackTrace(exception));
            return null;
        }
    }
}
