package com.bizvane.customized.facade.utils;

import com.bizvane.customized.facade.enums.ClearPointKeepYearEnum;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

@Component
public class ClearPointConvertDateUtils {

    /**
     *
     * @param type  1-前年 2-去年 3-当年
     * @param dateStr 字符串"MM-dd" 转日期
     * @return
     */
    public Date convertDate(int type, String dateStr) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-");
            String nowFormarStr = dateFormat.format(new Date());
            SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
            Date date = dateFormat2.parse(nowFormarStr + dateStr);
            Calendar keepSearchCalendar = Calendar.getInstance();
            keepSearchCalendar.setTime(date);
            if (ClearPointKeepYearEnum.THE_YEAR_BEFORE_LAST.getCode().equals(type)) {
                keepSearchCalendar.add(Calendar.YEAR, -2);
            } else if (ClearPointKeepYearEnum.LAST_YEAR.getCode().equals(type)) {
                keepSearchCalendar.add(Calendar.YEAR, -1);
            } else if (ClearPointKeepYearEnum.THIS_YEAR.getCode().equals(type)) {
                // 不处理
            }
            Date keepSearchDate = keepSearchCalendar.getTime();
            return keepSearchDate;
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 循环任务执行完毕，获取下一年时间
     * @param type  1-前年 2-去年 3-当年
     * @param dateStr 字符串"MM-dd" 转日期
     * @return
     */
    public Date newCreateTaskConvertDate(int type, String dateStr) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-");
            String nowFormarStr = dateFormat.format(new Date());
            SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
            Date date = dateFormat2.parse(nowFormarStr + dateStr);
            Calendar keepSearchCalendar = Calendar.getInstance();
            keepSearchCalendar.setTime(date);
            if (ClearPointKeepYearEnum.THE_YEAR_BEFORE_LAST.getCode().equals(type)) {
                keepSearchCalendar.add(Calendar.YEAR, -2);
            } else if (ClearPointKeepYearEnum.LAST_YEAR.getCode().equals(type)) {
                keepSearchCalendar.add(Calendar.YEAR, -1);
            } else if (ClearPointKeepYearEnum.THIS_YEAR.getCode().equals(type)) {
                // 不处理
            }
            keepSearchCalendar.add(Calendar.YEAR, 1);
            Date keepSearchDate = keepSearchCalendar.getTime();
            return keepSearchDate;
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 获取指定日期0点
     * @param date
     * @return
     */
    public Date getStartDate(Date date) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
            String dateStr = dateFormat2.format(date);
            return dateFormat.parse(dateStr+" 00:00:00");
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }
    /**
     * 循环任务执行完毕，获取下一年时间
     * @param date
     * @return
     */
    public Date getEndDate(Date date) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
            String dateStr = dateFormat2.format(date);
            return dateFormat.parse(dateStr+" 23:59:59");
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }
 }
