package com.bizvane.customized.facade.interfaces;

import com.bizvane.customized.facade.models.bo.Cus361SapAndCorpBo;
import com.bizvane.customized.facade.models.po.Cus361ChannelDataPO;
import com.bizvane.customized.facade.models.po.Cus361DistributorDataPo;
import com.bizvane.customized.facade.models.po.Cus361PrecinctAreaPO;
import com.bizvane.customized.facade.models.vo.Cus361RechargeCardListResponseVO;
import com.bizvane.customized.facade.models.vo.Cus361RechargeInfoRequestVo;
import com.bizvane.customized.facade.models.vo.Cus361RechargeRecordListResponseVo;
import com.bizvane.customized.facade.models.vo.Cus361RechargeRecordRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 *
 * @author admin
 * @date 2019/10/14
 */
@FeignClient(value = "${feign.client.customized.name}", path = "${feign.client.customized.path}/store")
@Api(tags = {"361接口"})
public interface Cus361RpcServiceFeign {

    /**
     * 添加或更新361渠道数据
     * @param jsonStr
     * @return
     */
    @PostMapping(value = "/channel")
    ResponseData addAndUpdate361ChannelData(@RequestBody String jsonStr);

    /**
     * 添加或更新361管辖区域数据
     * @param jsonStr
     * @return
     */
    @PostMapping(value = "/area")
    ResponseData addAndUpdate361PrecinctArea(@RequestBody String jsonStr);

    /**
     * 添加、更新门店档案信息（将数据同步到店铺表以及定制表）
     * @param jsonStr
     * @return
     */
    @PostMapping(value = "/sync")
    ResponseData addAndUpdateStoreFieldsInfo(@RequestBody String jsonStr);


    /**8
     * 根据会员卡号查询储值卡列表
     * @param rechargeInfoVo
     * @return
     */
    @PostMapping(value = "/getCardNoRechargeList")
    ResponseData<Cus361RechargeCardListResponseVO> getCardNoRechargeList(@RequestBody Cus361RechargeInfoRequestVo rechargeInfoVo) ;

    /**
     * 根据储值卡号查询储值流水记录
     * @param rechargeRecordVo
     * @return
     */
    @PostMapping("/getRechargeRecordListByPetCard")
    ResponseData<Cus361RechargeRecordListResponseVo> getRechargeRecordListByPetCard(@RequestBody Cus361RechargeRecordRequestVo rechargeRecordVo) ;


    /**
     * 根据店铺Code查询经销商、加盟商Code
     * @param storeCode
     * @return
     */
    @PostMapping(value = "/get361CodeByStoreCode")
    ResponseData<Cus361SapAndCorpBo> get361CodeByStoreCode(@RequestParam("storeCode") String storeCode);

    /**
     * 根据店铺Code查询经销商、加盟商
     * @param storeCode
     * @return
     */
    @RequestMapping(value = "/get361ByStoreCode", method = RequestMethod.POST)
    ResponseData<Cus361SapAndCorpBo> get361ByStoreCode(@RequestParam("storeCode") String storeCode);
    /**
     * 根据区域Code查询是否存在
     *
     * @param areaCode
     * @return
     */
    @RequestMapping(value = "/getAreaCode", method = RequestMethod.POST)
    ResponseData<Cus361PrecinctAreaPO> getPrecinctArea(@RequestParam("areaCode") String areaCode);

    /**
     * 根据加盟商Code查询是否存在
     *
     * @param sapCode
     * @return
     */
    @RequestMapping(value = "/getSapCode", method = RequestMethod.POST)
    ResponseData<Cus361ChannelDataPO> getSapCode(@RequestParam("sapCode") String sapCode);

    /**
     * 根据经销商Code查询是否存在
     *
     * @param corpCode
     * @return
     */
    @RequestMapping(value = "/getCorpCode", method = RequestMethod.POST)
    ResponseData<Cus361DistributorDataPo> getCorpCode(@RequestParam("corpCode") String corpCode);

    @RequestMapping(value = "/select361OrderIntegral", method = RequestMethod.POST)
    public ResponseData<Integer> select361OrderIntegral(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("orderNo")String orderNo);
}


