package com.bizvane.customized.facade.interfaces;

import com.bizvane.connectorservice.entity.common.RechargeRecordRequestVO;
import com.bizvane.customized.facade.models.bo.CardPasswordBO;
import com.bizvane.customized.facade.models.bo.CardResponseBo;
import com.bizvane.customized.facade.models.bo.RechargeCardBO;
import com.bizvane.customized.facade.models.bo.CusUrCardRefundRecordBO;
import com.bizvane.customized.facade.models.po.CusUrCardRefundRecordPO;
import com.bizvane.customized.facade.models.po.CusUrRechargeCardPO;
import com.bizvane.customized.facade.models.po.CusUrRechargeCardRecordPO;
import com.bizvane.customized.facade.models.vo.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import lombok.NonNull;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

@FeignClient(value="${feign.client.customized.name}",path="${feign.client.customized.path}/ur/rechargeCardRpc")
@Api(value = "储蓄卡相关接口",tags = {"储蓄卡"})
public interface RechargeCardServiceFeign {

    @PostMapping(value = "/addDebitCardRechargeRecord")
    ResponseData addDebitCardRechargeRecord(@RequestBody UrRechargeCardVo vo);


    @PostMapping(value = "/queryDebitCardInfo")
    ResponseData<List<CusUrRechargeCardPO>> queryDebitCardInfo(@RequestBody CusUrRechargeCardPO po);

    @PostMapping(value = "/addDebitCardRechargeCallBack")
    ResponseData addDebitCardRechargeCallBack(@RequestBody RechargeRecordRequestVO po);

    @PostMapping(value = "/queryUrMemberRechargeRecord")
    ResponseData<PageInfo<CusUrRechargeCardRecordPO>> queryUrMemberRechargeRecord(@RequestParam("memberCode")@NonNull String memberCode,
                                                                                  @RequestParam("pageNumber")@NonNull Integer pageNumber,
                                                                                  @RequestParam(value = "pageSize",defaultValue = "10")Integer pageSize,
                                                                                  @RequestParam(value = "type", defaultValue = "2") Integer type);

    @PostMapping("/getRechargeConfig")
    ResponseData<CusUrRechargeConfigVO> getRechargeConfig(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("sysBrandId") Long sysBrandId);


    @PostMapping("/getRechargeCardOne")
    ResponseData<CusUrMyRechargeCardVO> getRechargeCardOne(@RequestBody CusUrRechargeCardVO vo);

    @PostMapping("/getRechargeCardPassword")
    ResponseData<CusUrMyRechargeCardPwdVO> getRechargeCardPassword(@RequestBody CusUrRechargeCardVO vo);

    @PostMapping("/getRechargeCardRecharge")
    ResponseData<CusUrRechargeCardRechargeVO> getRechargeCardRecharge(@RequestBody CusUrRechargeCardVO vo);

    @PostMapping("/queryRechargeCard")
    public ResponseData<RechargeCardBO> queryRechargeCard(@RequestParam(value="rechargeCardCode",required = false) String rechargeCardCode,@RequestParam(value="cardCode",required = false) String cardCode, @RequestParam("brandId") Long brandId, @RequestParam("companyId") Long companyId) ;

    @PostMapping("/rechargeCardConsume")
    public ResponseData<CardResponseBo> rechargeCardConsume(@RequestBody RechargeCardConsumeVO vo) throws Exception;

    @PostMapping("/rechargeCardOrderReturns")
    public ResponseData<CardResponseBo> rechargeCardOrderReturns(@RequestBody RechargeCardModifyVO vo) throws Exception;

    @PostMapping("/rechargeCardPassword")
    public ResponseData<CardPasswordBO> rechargeCardPassword(@RequestParam("rechargeCardNo") String rechargeCardNo,
                                                                 @RequestParam("cardCode") String cardCode,
                                                                 @RequestParam("password") String password,
                                                                 @RequestParam("brandId") Long brandId,
                                                                 @RequestParam("companyId") Long companyId) ;

    @PostMapping("/sendSmsAuthCode")
    public ResponseData sendSmsAuthCode(@RequestBody SendSmsAuthCodeVo vo) ;

    @PostMapping("/queryRechargeCardPass")
    public ResponseData queryRechargeCardPass(@RequestBody CusUrRechargeCardPassVo vo) ;

    @PostMapping("/queryRechargeCardStyle")
    public ResponseData<List<CusUrRechargeCardStyleVO>> queryRechargeCardStyle(@RequestBody CusUrRechargeCardVO vo);

    @PostMapping("/changeRechargeCardStyle")
    public ResponseData changeRechargeCardStyle(@RequestBody CusUrMyRechargeCardVO vo);

    @PostMapping("/updateRechargeCardPassword")
    public ResponseData updateRechargeCardPassword(@RequestBody CusUrRechargeCardPwdVO vo);

    @PostMapping("/transfer")
    public ResponseData<Long> transfer(@RequestBody CusUrTransferVo vo);

    @PostMapping("/getReceiveTransferPageInfo")
    public ResponseData<CusUrReceiveTransferPageVo> getReceiveTransferPageInfo(@RequestParam("rechargeRecordId") Long rechargeRecordId);

    @PostMapping("/receiveTransfer")
    public ResponseData<String> receiveTransfer(@RequestBody CusUrReceiveTransferVo vo);

    @PostMapping("/getTransferPageInfo")
    public ResponseData<CusUrTransferPageVo> getTransferPageInfo(@RequestBody CusUrTransferPageReqVo vo);

    @PostMapping("/getRechargeCardPayRecord")
    public ResponseData<CusUrRechargeCardRecordPO> getRechargeCardPayRecord(@RequestParam("orderNo")String orderNo,
                                                                            @RequestParam("sysCompanyId")Long sysCompanyId,
                                                                            @RequestParam("sysBrandId")Long sysBrandId);

    @PostMapping("/getSign")
    public ResponseData<String> getSign();

    @PostMapping("/cancelTransfer")
    public ResponseData cancelTransfer(@RequestParam("rechargeRecordId") Long rechargeRecordId);

    @PostMapping("/queryUrCardRefundRecord")
    ResponseData<List<CusUrCardRefundRecordPO>> queryUrCardRefundRecord(@RequestBody CusUrCardRefundRecordBO bo);

    /**
     * 充值卡余额调整接口
     * */
    @PostMapping("/adjustRechargeCard")
    ResponseData<CardResponseBo> adjustRechargeCard(@RequestBody RechargeCardModifyVO vo) throws Exception;

    /**
     * 充值卡 退款申请中 状态修改接口
     * @param requestVo
     * @return
     * @throws Exception
     * */
    @PostMapping("/modifyRefundStatus")
    ResponseData modifyRefundStatus(@RequestBody RechargeCardStatusRequestVo requestVo) throws Exception;

}
