package com.bizvane.customized.facade.enums;

/**
 * @author kitandrew
 * @version 1.0.0
 * @EnumName CusUrRechargeStatusEnum.java
 * @Description UR充值卡充值/转赠状态
 * @createTime 2020年04月01日 09:16:00
 */
public enum CusUrRechargeStatusEnum {
    UNACCOUNTED(0,"未到账"),
    ARRIVED(1,"已到账"),
    WAIT_RECEIVE(2,"待领取"),
    RECEIVED(3,"已领取"),
    EXPIRED(4,"已过期"),
    CANCEL(5,"已撤回");

    private Integer typeCode;

    private String typeName;

    public Integer getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(Integer typeCode) {
        this.typeCode = typeCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    CusUrRechargeStatusEnum(Integer typeCode, String typeName) {
        this.typeCode = typeCode;
        this.typeName = typeName;
    }
}
