package com.bizvane.customized.facade.utils;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.customized.facade.models.vo.SendTemplateVo;
import com.bizvane.messagefacade.enums.MsgTemplateType;
import com.bizvane.messagefacade.interfaces.TemplateMessageServiceFeign;
import com.bizvane.messagefacade.models.vo.GenMessageVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;

@Slf4j
@Component
public class SendWxNotificationUtil {

    @Autowired
    private TemplateMessageServiceFeign templateMessageServiceFeign;

    /**
     * 余额变动提醒
     *
     */
    public void sendMemberBalanceTempalteMsg(SendTemplateVo templateVo) {

        log.info("enter sendMemberBalanceTempalteMsg param:{}", JacksonUtil.bean2Json(templateVo));

        if (templateVo == null) {
            log.error("sendMemberBalanceTempalteMsg找不到会员 param:{}", JacksonUtil.bean2Json(templateVo));
            return;
        }
        GenMessageVO vo = new GenMessageVO();
        vo.setMemberCode(templateVo.getMemberCode());
        vo.setSysBrandId(templateVo.getSysBrandId());
        vo.setSysCompanyId(templateVo.getSysCompanyId());
        vo.setTemplateType(MsgTemplateType.CHU_ZHI_GEN_WXTEMPLATE_MESSAGE.getCode());
        JSONObject messagejo = new JSONObject();
        if (templateVo.getState() == 0) {
            messagejo.put("first", "您完成了一笔充值业务。");//
        } else {
            messagejo.put("first", "您有一笔余额支出。");//
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        messagejo.put("keyword1", "账户余额变动");// 变动类型：账户余额变动
        messagejo.put("keyword2", templateVo.getRechargeMoney());// 变动金额：200
        messagejo.put("keyword3", templateVo.getBalance() != null ? templateVo.getBalance() : "");// 剩余余额：2000
        messagejo.put("keyword4", "");

        messagejo.put("keyword5", sd.format(templateVo.getPaymentDate()));// 变动日期：2019－03－05
        messagejo.put("keyword6", templateVo.getCardNo());
        messagejo.put("keyword7", templateVo.getSerialNumber());
        messagejo.put("keyword8", templateVo.getName());
        messagejo.put("remark", "感谢您的支持");
        messagejo.put("phoneStr", templateVo.getPhone());
        vo.setMessagejo(messagejo);
        log.info("sendMemberBalanceTempalteMsg param:{}", JacksonUtil.bean2Json(vo));
        templateMessageServiceFeign.sendWxGenTemplateMessage(vo);
    }
}
