package com.bizvane.customized.facade.interfaces;

import com.bizvane.customized.facade.models.vo.Cus361RechargeCardListResponseVO;
import com.bizvane.customized.facade.models.vo.Cus361RechargeInfoRequestVo;
import com.bizvane.customized.facade.models.vo.Cus361RechargeRecordListResponseVo;
import com.bizvane.customized.facade.models.vo.Cus361RechargeRecordRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * Created by admin on 2019/10/14.
 */
@FeignClient(value = "${feign.client.customized.name}", path = "${feign.client.customized.path}/store")
@Api(tags = {"361接口"}, description = "")
public interface Cus361RpcServiceFeign {

    /**
     * 添加或更新361渠道数据
     * @param jsonStr
     * @return
     */
    @PostMapping(value = "/channel")
    ResponseData addAndUpdate361ChannelData(@RequestBody String jsonStr);

    /**
     * 添加或更新361管辖区域数据
     * @param jsonStr
     * @return
     */
    @PostMapping(value = "/area")
    ResponseData addAndUpdate361PrecinctArea(@RequestBody String jsonStr);

    /**
     * 添加、更新门店档案信息（将数据同步到店铺表以及定制表）
     * @param jsonStr
     * @return
     */
    @PostMapping(value = "/sync")
    ResponseData addAndUpdateStoreFieldsInfo(@RequestBody String jsonStr);


    /**8
     * 根据会员卡号查询储值卡列表
     * @param rechargeInfoVo
     * @return
     */
    @PostMapping(value = "/getCardNoRechargeList")
    ResponseData<Cus361RechargeCardListResponseVO> getCardNoRechargeList(@RequestBody Cus361RechargeInfoRequestVo rechargeInfoVo) ;

    /**
     * 根据储值卡号查询储值流水记录
     * @param rechargeRecordVo
     * @return
     */
    @PostMapping("/getRechargeRecordListByPetCard")
    ResponseData<Cus361RechargeRecordListResponseVo> getRechargeRecordListByPetCard(@RequestBody Cus361RechargeRecordRequestVo rechargeRecordVo) ;

    }
