package com.bizvane.couponfacade.models.vo;


import com.bizvane.members.facade.models.MemberInfoModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

@Data
@ToString
public class CouponListByMemberCodeRequestVO implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @io.swagger.annotations.ApiModelProperty(value = "品牌id", name = "sysBrandId", required = false,example = "")
  private Long sysBrandId;

  @io.swagger.annotations.ApiModelProperty(value = "公司id", name = "sysCompanyId", required = false,example = "")
  private Long sysCompanyId;

  @io.swagger.annotations.ApiModelProperty(value = "会员号", name = "memberCode", required = false,example = "")
  private String memberCode;

  private String couponCode;

  @io.swagger.annotations.ApiModelProperty(value = "会员号list", name = "membersCodeList", required = false,example = "")
  private List <String> membersCodeList;

  @ApiModelProperty(value = "券使用状态：20-未使用，25-已过期，30-已核销，35-已作废", name = "couponStatus")
  private Byte couponStatus;

  @io.swagger.annotations.ApiModelProperty(value = "显示条数", name = "pageSize")
  private Integer pageSize;

  @io.swagger.annotations.ApiModelProperty(value = "当前页数", name = "page")
  private Integer pageNumber;

    /**
     * 小程序版本号(做版本兼容用)。2020.10.30 此时为 1
     */
  private Integer appEdition;
  @io.swagger.annotations.ApiModelProperty(value = "发放状态", name = "sendStatus")
  private Byte sendStatus;
  @io.swagger.annotations.ApiModelProperty(value = "发放失败原因", name = "sendFailReason")
  private String sendFailReason;
  @io.swagger.annotations.ApiModelProperty(value = "发放类型（10-开卡发券，15-会员生日，20-受赠，25-积分兑换，30-线上开卡，35-会员升级，--40-会员生日，45-会员消费，50-会员签到，55-领券，60-完善资料，65-微信分享，70-消费次数，75-消费金额，80-邀请开卡,85-批量发券,90-入会纪念日,95-定向营销 ，100 - 评价奖励活动，101 - 积分商城，103大转盘，104红包膨胀，105-砸金蛋，106-宝宝生日活动，107-会员首单活动，108-摇一摇，109-储值送礼，110-预生成券，111-员工券，115 - 线下ERP发券）", name = "sendType", required = false, example = "")
  private String sendType;
  //会员code集合
  private List<MemberInfoModel> memberCodeList;

  @io.swagger.annotations.ApiModelProperty(value = "发放状态集合", name = "couponStatusList", required = false, example = "")
  private List<Byte> couponStatusList;

  @io.swagger.annotations.ApiModelProperty(value = "couponName", name = "couponName")
  private String couponName;

  public Long getSysCompanyId() {
    return sysCompanyId;
  }

  public void setSysCompanyId(Long sysCompanyId) {
    this.sysCompanyId = sysCompanyId;
  }

  public Long getSysBrandId() {
    return sysBrandId;
  }

  public void setSysBrandId(Long sysBrandId) {
    this.sysBrandId = sysBrandId;
  }

  public String getMemberCode() {
    return memberCode;
  }

  public void setMemberCode(String memberCode) {
    this.memberCode = memberCode;
  }

  public List<String> getMembersCodeList() {
    return membersCodeList;
  }

  public void setMembersCodeList(List<String> membersCodeList) {
    this.membersCodeList = membersCodeList;
  }

  public Byte getCouponStatus() {
    return couponStatus;
  }

  public void setCouponStatus(Byte couponStatus) {
    this.couponStatus = couponStatus;
  }

  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  public Integer getPageNumber() {
    return pageNumber;
  }

  public void setPageNumber(Integer pageNumber) {
    this.pageNumber = pageNumber;
  }

  public Integer getAppEdition() {
      return appEdition;
  }

  public void setAppEdition(Integer appEdition) {
      this.appEdition = appEdition;
  }

  public List<MemberInfoModel> getMemberCodeList() {
    return memberCodeList;
  }

  public void setMemberCodeList(List<MemberInfoModel> memberCodeList) {
    this.memberCodeList = memberCodeList;
  }

  public Byte getSendStatus() {
    return sendStatus;
  }

  public void setSendStatus(Byte sendStatus) {
    this.sendStatus = sendStatus;
  }

  public String getSendFailReason() {
    return sendFailReason;
  }

  public void setSendFailReason(String sendFailReason) {
    this.sendFailReason = sendFailReason;
  }

  public String getSendType() {
    return sendType;
  }

  public void setSendType(String sendType) {
    this.sendType = sendType;
  }

  public List<Byte> getCouponStatusList() {
    return couponStatusList;
  }

  public void setCouponStatusList(List<Byte> couponStatusList) {
    this.couponStatusList = couponStatusList;
  }

  public String getCouponName() {
    return couponName;
  }

  public void setCouponName(String couponName) {
    this.couponName = couponName;
  }
}
