package com.bizvane.couponfacade.models.bo;

import com.bizvane.centerstageservice.models.po.SysProductCategoryPo;
import com.bizvane.centerstageservice.models.vo.SelectCacheKeyVo;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import lombok.ToString;

import java.util.List;
import java.util.Map;

/**
 * @Author: lijunwei
 * @Time: 2020/2/26 15:27
 */
@ToString
public class CouponDefinitionBO extends CouponDefinitionPOWithBLOBs {
    private Map<String, List<SysProductCategoryPo>> map;

    // 商品属性
    private List<SysProductCategoryPo> commodityAttributeList;
    //部分适用商品类型 1:黑名单商品 2：单一白名单商品 3：商品属性 4：复合白名单商品
    private Byte commodityLimitType;
    //部分门店 1：白名单门店 0:黑名单
    private Byte storeListType;

    //店铺、导购缓存key
    private SelectCacheKeyVo selectCacheKeyVo;

    //运营组织名称
    private String organizationName;

    public Map<String, List<SysProductCategoryPo>> getMap() {
        return map;
    }

    public void setMap(Map<String, List<SysProductCategoryPo>> map) {
        this.map = map;
    }

    public List<SysProductCategoryPo> getCommodityAttributeList() {
        return commodityAttributeList;
    }

    public void setCommodityAttributeList(List<SysProductCategoryPo> commodityAttributeList) {
        this.commodityAttributeList = commodityAttributeList;
    }

    public Byte getCommodityLimitType() {
        return commodityLimitType;
    }

    public void setCommodityLimitType(Byte commodityLimitType) {
        this.commodityLimitType = commodityLimitType;
    }

    public Byte getStoreListType() {
        return storeListType;
    }

    public void setStoreListType(Byte storeListType) {
        this.storeListType = storeListType;
    }

    public SelectCacheKeyVo getSelectCacheKeyVo() {
        return selectCacheKeyVo;
    }

    public void setSelectCacheKeyVo(SelectCacheKeyVo selectCacheKeyVo) {
        this.selectCacheKeyVo = selectCacheKeyVo;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }
}
