package com.bizvane.couponfacade.models.vo;

import java.math.BigDecimal;
import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import com.bizvane.connectorservice.entity.common.CouponRequestVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

/**
 * 补发券
 * Created by yunjie.tian on 2018/8/21.
 */
@Data
@ToString
public class CouponSendAgainRequestVO {

  @ApiModelProperty(
      value = "线上品牌id",
      name = "brandId",
      required = true,
      example = "1"
    )
    private Long brandId;
    
    @ApiModelProperty(
          value = "线下品牌code",
          name = "offlineBrandCode",
          example = "002"
    )
    private String offlineBrandCode;
    
    @ApiModelProperty(
          value = "全局uuid(查询线上线下日志使用)",
          name = "sessionTokenId",
          required = false,
          example = "688a0a5f-c1d1-4d27-8aa2-b52d56c18924"
    )
    private String sessionTokenId;
    
    @ApiModelProperty(
          value = "大类",
          name = "bigCategory",
          required = false,
          example = "可选"
    )
    private String bigCategory;
    
    @ApiModelProperty(
          value = "中类",
          name = "middleCategory",
          required = false,
          example = "可选"
    )
    private String middleCategory;
    
    
    @ApiModelProperty(
          value = "小类",
          name = "samllCategory",
          required = false,
          example = "可选"
    )
    private String smallCategory;
    
    @ApiModelProperty(
          value = "年份",
          name = "particularYear",
          required = false,
          example = "可选"
    )
    private String particularYear;
    
    @ApiModelProperty(
          value = "季节",
          name = "season",
          required = false,
          example = "可选"
    )
    private String season;
    
    @ApiModelProperty(
          value = "线下组织code",
          name = "offlineOrgCodes",
          required = false,
          example = ""
    )
    private String offlineOrgCodes;
    
    @ApiModelProperty(
          value = "商品购买件数限制",
          name = "goodsCondition",
          required = false,
          example = ""
    )
    private Integer goodsCondition;
    
    @ApiModelProperty(
          value = "可选线下组织code",
          name = "couponDefOrgOfflineCodes",
          required = false,
          example = ""
    )
    private String couponDefOrgOfflineCodes;

  @ApiModelProperty(
      value = "券名称",
      name = "couponName",
      required = false,
      example = ""
    )
    private String couponName;
    /**
    * 券定义code
    */
    private String couponDefinitionCode;
    @ApiModelProperty(
          value = "券号",
          name = "couponCode",
          required = false,
          example = ""
    )
    private String couponCode;
    @ApiModelProperty(
          value = "会员code",
          name = "memberCode",
          required = false,
          example = ""
    )
    private String memberCode;
    @ApiModelProperty(
          value = "会员线下id",
          name = "erpId",
          required = false,
          example = ""
    )
    private String erpId;
    @ApiModelProperty(
          value = "绑定状态（0未绑定，1已绑定）",
          name = "bindStatus",
          required = false,
          example = ""
    )
    private Boolean bindStatus;
    @ApiModelProperty(
          value = "核销密码",
          name = "usePassword",
          required = false,
          example = ""
    )
    private String usePassword;
    @ApiModelProperty(
          value = "发放类型（10-开卡发券，15-生日发券，20-受赠，25-积分兑换，30-线上开卡，35-会员升级，40-会员生日，45-会员消费，50-会员签到，55-领券，60-完善资料，65-微信分享，70-消费次数，75-消费金额，80-邀请开卡,85-批量发券,90-入会纪念日,95-定向营销 ，100 - 评价奖励活动，101 - 积分商城，103大转盘，104红包膨胀，105-砸金蛋，106-宝宝生日活动，107-会员首单活动，108-摇一摇，109-储值送礼，110-预生成券，111-员工券，115 - 线下ERP发券，120 - 天猫券）",
          name = "sendType",
          required = false,
          example = ""
    )
    private String sendType;
    @ApiModelProperty(
          value = "发券业务单号(手工发券id)",
          name = "sendBusinessId",
          required = false,
          example = ""
    )
    private Long sendBusinessId;
    @ApiModelProperty(
          value = "使用类型：1-线上，2-线下",
          name = "useType",
          required = false,
          example = ""
    )
    private Byte useType;
    @ApiModelProperty(
          value = "核销门店",
          name = "useStoreId",
          required = false,
          example = ""
    )
    private String useStoreId;
    @ApiModelProperty(
          value = "券使用业务单号",
          name = "useBusinessCode",
          required = false,
          example = ""
    )
    private String useBusinessCode;
    @ApiModelProperty(
          value = "使用时间",
          name = "useTime",
          required = false,
          example = ""
    )
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date useTime;
    @ApiModelProperty(
          value = "是否使用(1-已使用，0-未使用)",
          name = "isUse",
          required = false,
          example = ""
    )
    private Boolean isUse;
    @ApiModelProperty(
          value = "渠道限制（1仅线上，2仅线下，3全渠道）",
          name = "useChannel",
          required = false,
          example = ""
    )
    private Byte useChannel;
    @ApiModelProperty(
          value = "优惠类型（1现金，2折扣，3礼品）",
          name = "preferentialType",
          required = false,
          example = ""
    )
    private Byte preferentialType;
    @ApiModelProperty(
          value = "面额",
          name = "money",
          required = false,
          example = ""
    )
    private BigDecimal money;
    @ApiModelProperty(
          value = "折扣",
          name = "discount",
          required = false,
          example = ""
    )
    private BigDecimal discount;
    @ApiModelProperty(
          value = "有效期开始时间",
          name = "validDateStart",
          required = false,
          example = ""
    )
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date validDateStart;
    @ApiModelProperty(
          value = "有效期结束时间",
          name = "validDateEnd",
          required = false,
          example = ""
    )
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date validDateEnd;
    @ApiModelProperty(
          value = "二维码",
          name = "qrCode",
          required = false,
          example = ""
    )
    private String qrCode;
    @ApiModelProperty(
          value = "券模板图片",
          name = "img",
          required = false,
          example = ""
    )
    private String img;
    @ApiModelProperty(
          value = "单人最大领取数量限制",
          name = "perMaxNum",
          required = false,
          example = ""
    )
    private Integer perMaxNum;
    @ApiModelProperty(
          value = "是否记名（1记名，0不记名）",
          name = "isRealName",
          required = false,
          example = ""
    )
    private Boolean isRealName;
    @ApiModelProperty(
          value = "是否允许转赠（1允许转赠，0不允许转赠）",
          name = "isTransfer",
          required = false,
          example = ""
    )
    private Boolean isTransfer;
    @ApiModelProperty(
          value = "活动叠加白名单",
          name = "activitySuperpositionWhiteList",
          required = false,
          example = ""
    )
    private String activitySuperpositionWhiteList;
    @ApiModelProperty(
          value = "活动叠加黑名单",
          name = "activitySuperpositionBlackList",
          required = false,
          example = ""
    )
    private String activitySuperpositionBlackList;
    @ApiModelProperty(
          value = "是否允许叠加（1是，0否）",
          name = "isSuperposition",
          required = false,
          example = ""
    )
    private Boolean isSuperposition;
    @ApiModelProperty(
          value = "正价购买限制",
          name = "isTagPriceLimit",
          required = false,
          example = ""
    )
    private Boolean isTagPriceLimit;
    @ApiModelProperty(
          value = "最低消费金额(满减金额)",
          name = "minConsume",
          required = false,
          example = ""
    )
    private BigDecimal minConsume;
    @ApiModelProperty(
          value = "最高优惠金额",
          name = "maxPreferential",
          required = false,
          example = ""
    )
    private BigDecimal maxPreferential;
    @ApiModelProperty(
          value = "商品数量最低限制",
          name = "minCommodityNum",
          required = false,
          example = ""
    )
    private Integer minCommodityNum;
    @ApiModelProperty(
          value = "商品数量最高限制",
          name = "maxCommodityNum",
          required = false,
          example = ""
    )
    private Integer maxCommodityNum;
    @ApiModelProperty(
          value = "整单最低折扣限制",
          name = "minDiscount",
          required = false,
          example = ""
    )
    private BigDecimal minDiscount;
    @ApiModelProperty(
          value = "适用商品类型：1-全部适用，2-部分适用",
          name = "applianceCommodityType",
          required = false,
          example = ""
    )
    private Byte applianceCommodityType;
    @ApiModelProperty(
          value = "适用门店类型：1-全部适用，2-部分适用",
          name = "applianceStoreType",
          required = false,
          example = ""
    )
    private Byte applianceStoreType;
    @ApiModelProperty(
          value = "商品白名单",
          name = "commodityWhitelist",
          required = false,
          example = ""
    )
    private String commodityWhitelist;
    @ApiModelProperty(
          value = "商品黑名单",
          name = "commodityBlacklist",
          required = false,
          example = ""
    )
    private String commodityBlacklist;
    @ApiModelProperty(
          value = "门店白名单",
          name = "storeWhitelist",
          required = false,
          example = ""
    )
    private String storeWhitelist;
    @ApiModelProperty(
          value = "门店黑名单",
          name = "storeBlacklist",
          required = false,
          example = ""
    )
    private String storeBlacklist;
    
    /**
    * 是否补发0=否，1=是
    */
    private Integer idReissue;
    
    @ApiModelProperty(
          value = "走批量或预生成券(空:批量，1:预生成)",
          name = "type",
          required = false,
          example = ""
    )
    private String type;
    
    @ApiModelProperty(
          value = "是否允许券数小于商品数,1:允许,0:不允许",
          name = "isCouponLessGoods",
          required = false,
          example = ""
    )
    private String isCouponLessGoods;

    private String batchSendCode;

    private Long sysBrandId;

    private Long couponEntityId;

    private Long couponSendFailLogId;

    private Long couponDefinitionId;
    
	private Byte couponDefinitionType;

    private String offlinePrdCode;

    private Long sysCompanyId;

    private String organizationCode;

    private Integer applianceOrgType;

    private String applianceOrgCodes;

    
}
