package com.bizvane.couponfacade.models.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.math.BigDecimal;
import java.util.Date;


/**
 * @author baofeng@zhidemai.com
 * @createTime 2023-03-29 13:43:22
 * @description: 侧边栏送券列表查询结果对象
 */
@ApiModel(value = "侧边栏送券列表查询结果对象")
@Data
@NoArgsConstructor
@AllArgsConstructor(access = AccessLevel.PACKAGE)
@Builder
public class CouponQuotaSendDetailListResponseVO {

    @ApiModelProperty(name = "sysCompanyId", value = "企业ID", required = false, example = "1L")
    private Long sysCompanyId;

    @ApiModelProperty(name = "sysBrandId", value = "品牌ID", required = false, example = "1L")
    private Long sysBrandId;

    @ApiModelProperty(name = "storeName", value = "店铺名称", example = "")
    private String storeName;

    @ApiModelProperty(name = "sysStoreOnlineCode", value = "店铺编号", example = "")
    private String sysStoreOnlineCode;

    @ApiModelProperty(name = "staffName", value = "导购名称", example = "")
    private String staffName;

    @ApiModelProperty(name = "staffCode", value = "导购编号", example = "")
    private String staffCode;

    @ApiModelProperty(name = "couponName", value = "券名称", example = "")
    private String couponName;

    @ApiModelProperty(name = "couponCode", value = "券号", example = "")
    private String couponCode;

    @ApiModelProperty(name = "couponMoney", value = "券面额", example = "")
    private BigDecimal couponMoney;

    @ApiModelProperty(name = "sendTime", value = "赠送时间", example = "")
    private Date sendTime;

    @ApiModelProperty(name = "receiveTime", value = "领取时间", example = "")
    private Date receiveTime;

    @ApiModelProperty(name = "couponStatue", value = "券状态，19-未领取（商秀导购侧边栏发券新增状态），20-未使用(已领取)，25-已过期，30-已核销", example = "")
    private Integer couponStatue;

    @ApiModelProperty(name = "memberCode", value = "会员Code", example = "")
    private String memberCode;

    @ApiModelProperty(name = "memberName", value = "会员Name", example = "")
    private String memberName;

    @ApiModelProperty(name = "memberPhone", value = "会员手机号", example = "")
    private String memberPhone;

    @ApiModelProperty(name = "memberCardNo", value = "会员卡号", example = "")
    private String memberCardNo;

    @ApiModelProperty(name = "isReceived", value = "是否已领取，1-是，0-否", example = "")
    private Integer isReceived;


}