package com.bizvane.couponfacade.interfaces;

import java.util.List;

import javax.validation.Valid;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bizvane.base.common.bean.ListResultBean;
import com.bizvane.couponfacade.models.bo.AvailableCouponDto;
import com.bizvane.couponfacade.models.bo.CertificateDto;
import com.bizvane.couponfacade.models.bo.CouponDetailsDto;
import com.bizvane.couponfacade.models.bo.RefundVoucherDto;
import com.bizvane.couponfacade.models.bo.VoucherIssuanceDto;
import com.bizvane.couponfacade.models.bo.VoucherVerificationDto;
import com.bizvane.couponfacade.models.bo.YzCouponDefinitionRequest;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.vo.AvailableCouponVo;
import com.bizvane.couponfacade.models.vo.CertificateVo;
import com.bizvane.couponfacade.models.vo.CouponDetailsVo;
import com.bizvane.couponfacade.models.vo.VoucherIssuanceVo;
import com.bizvane.couponfacade.models.vo.VoucherVerificationVo;
import com.bizvane.utils.responseinfo.ResponseData;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@FeignClient(value="${feign.client.coupon.name}",path="${feign.client.coupon.path}/youzan/coupon")
@Api(value = "有赞券",tags = {"API"})
public interface YouZanCouponServiceFeign {
    
  
    @ApiOperation(value = "查询活动信息 (券定义信息)", notes = "查询活动信息 (券定义信息)",httpMethod = "POST")
    @RequestMapping(value="/queryCouponDefinitionInfo", method = RequestMethod.POST)
    ResponseData<CouponDefinitionPOWithBLOBs> queryCouponDefinitionInfo(@RequestBody @Valid YzCouponDefinitionRequest yzCouponDefinitionRequest);

    @ApiOperation(value = "下单前置页获取可用券列表(获取会员的可用券列表)", notes = "下单前置页获取可用券列表(获取会员的可用券列表)", httpMethod = "POST")
    @PostMapping("/queryCouponByYzOpenId")
    ResponseData<List<AvailableCouponDto>> queryCouponByYzOpenId(@RequestBody @Valid AvailableCouponVo availableCouponVo);
    
    @ApiOperation(value = "查询买家优惠凭证列表", notes = "查询买家优惠凭证列表", httpMethod = "POST")
    @PostMapping("/queryCertificateByYzOpenId")
    ListResultBean<CertificateDto> queryCertificateByYzOpenId(@RequestBody @Valid CertificateVo certificateVo);
    
    @ApiOperation(value = "查询凭证详情信息(券详情)", notes = "查询凭证详情信息(券详情)")
    @PostMapping("/queryCouponInfo")
    ResponseData<CouponDetailsDto> queryCouponInfo(@RequestBody @Valid CouponDetailsVo queryCouponInfoVo);
    
    @ApiOperation(value = "凭证发放", notes = "凭证发放")
    @PostMapping("/sendCoupon")
    ResponseData<VoucherIssuanceDto> sendCoupon(@RequestBody @Valid VoucherIssuanceVo param);
    
    @ApiOperation(value = "核销凭证", notes = "核销凭证")
    @PostMapping("/useCoupon")
    ResponseData<VoucherVerificationDto> useCoupon(@RequestBody @Valid VoucherVerificationVo param);
    
    @ApiOperation(value = "10.退还凭证", notes = "10.退还凭证")
    @PostMapping("/reversal")
    ResponseData<RefundVoucherDto> reversal(@RequestBody @Valid VoucherVerificationVo param);
    
   
}
