package com.bizvane.couponfacade.interfaces;

import com.bizvane.couponfacade.models.vo.StaffSendCouponCountResponseVO;
import com.bizvane.couponfacade.models.vo.StaffSendCouponListRequestVO;
import com.bizvane.couponfacade.models.vo.StaffSendCouponListResponseVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.validation.Valid;

/**
 * @author baofeng@zhidemai.com
 * @createTime 2023-04-06 11:18:20
 * @description: 导购发送优惠券流水相关业务接口
 */
@FeignClient(value = "${feign.client.coupon.name}", path = "${feign.client.coupon.path}/couponQuotaSendDetail")
@Api(value = "导购发送优惠券流水相关业务接口", tags = {"导购发送优惠券流水相关业务接口"})
public interface CouponQuotaSendDetailServiceFeign {
    @ApiOperation(value = "商秀-企微导购领券分析-分页查询企微导购侧边栏发券记录", tags = {"商秀-企微导购领券分析-分页查询企微导购侧边栏发券记录"}, httpMethod = "POST")
    @ResponseBody
    @PostMapping(value = "/pageListByStaffCode")
    ResponseData<PageInfo<StaffSendCouponListResponseVO>> pageListByStaffCode(@Valid @RequestBody StaffSendCouponListRequestVO reqVO);

    @ApiOperation(value = "商秀-企微导购领券分析-查询已领取和未领取券数量", tags = {"商秀-企微导购领券分析-查询已领取和未领取券数量"}, httpMethod = "POST")
    @ResponseBody
    @PostMapping(value = "/countSendCoupon")
    ResponseData<StaffSendCouponCountResponseVO> countSendCoupon(@Valid @RequestBody StaffSendCouponListRequestVO reqVO);

}
