package com.bizvane.couponfacade.models.vo;

import com.bizvane.utils.tokens.SysAccountPO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("创建支付宝商家券预生成券任务")
public class PreGeneratedCouponAlipayTaskCreateVO {

    @ApiModelProperty(value = "券定义id", required = true)
    private Long couponDefinitionId;

    @ApiModelProperty(value = "任务名称", required = true)
    private String taskName;

    @ApiModelProperty(value = "发券总数量", required = true)
    private Integer totalNumber;

    @ApiModelProperty(value = "支付宝商家券投放记录id", required = true)
    private Long mktActivityAlipayVoucherRecordId;

    @ApiModelProperty(value = "支付宝商家券活动id", required = true)
    private Long mktActivityId;

    private SysAccountPO sysAccountPO;
}
