package com.bizvane.couponfacade.models.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author baofeng@bizvane.cn
 * @createTime 2021-10-18 18:07:14
 * @description: 查询优惠券列表结果对象
 */
@Deprecated
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponInfoDTO {

    @ApiModelProperty(value = "pkID", name = "couponEntityId", required = false, example = "")
    private Long couponEntityId;

    @ApiModelProperty(value = "所属企业id", name = "sysCompanyId", required = false, example = "")
    private Long sysCompanyId;

    @ApiModelProperty(value = "所属品牌id", name = "sysBrandId", required = false, example = "")
    private Long sysBrandId;

    @ApiModelProperty(value = "所属品牌编号", name = "brandCode", required = false, example = "")
    private String brandCode;

    @ApiModelProperty(value = "任务名称", name = "businessName", required = false, example = "")
    private String businessName;

    @ApiModelProperty(value = "券号", name = "couponCode", required = false, example = "")
    private String couponCode;

    @ApiModelProperty(value = "券定义id", name = "couponDefinitionId", required = false, example = "")
    private String couponDefinitionId;

    @ApiModelProperty(value = "券发送记录id", name = "couponBatchSendRecordId", required = false, example = "")
    private Long couponBatchSendRecordId;

    @ApiModelProperty(value = "会员code", name = "memberCode", required = false, example = "")
    private String memberCode;

    @ApiModelProperty(value = "券名称", name = "couponName", required = false, example = "")
    private String couponName;

    @ApiModelProperty(value = "面额", name = "money", required = false, example = "")
    private BigDecimal money;

    @ApiModelProperty(value = "折扣", name = "discount", required = false, example = "")
    private BigDecimal discount;

    @ApiModelProperty(value = "券模板图片", name = "img", required = false, example = "")
    private String img;

    @ApiModelProperty(value = "券说明", name = "info", required = false, example = "")
    private String info;

    @ApiModelProperty(value = "绑定状态（0未绑定，1已绑定）", name = "bindStatus", required = false, example = "")
    private Boolean bindStatus;

    @ApiModelProperty(value = "有效期开始时间", name = "validDateStart", required = false, example = "")
    private Date validDateStart;

    @ApiModelProperty(value = "有效期结束时间", name = "validDateEnd", required = false, example = "")
    private Date validDateEnd;

    @ApiModelProperty(value = "是否锁定(0-未锁定 1-锁定)", name = "isLock", required = false, example = "")
    private Boolean isLock;

    @ApiModelProperty(value = "核销密码", name = "usePassword", required = false, example = "")
    private String usePassword;

    @ApiModelProperty(value = "发放类型（10-开卡发券，15-会员生日，20-受赠，25-积分兑换，30-线上开卡，35-会员升级，--40-会员生日，" +
            "45-会员消费，50-会员签到，55-领券，60-完善资料，65-微信分享，70-消费次数，75-消费金额，80-邀请开卡, 81-调查问卷,85-批量发券," +
            "90-入会纪念日,95-定向营销 ，100 - 评价奖励活动，101 - 积分商城，103大转盘，104红包膨胀，105-砸金蛋，106-宝宝生日活动，" +
            "107-会员首单活动，108-摇一摇，109-储值送礼，110-预生成券，111-员工券，115 - 线下ERP发券，120 - 天猫券，125 - 线下领券）",
            name = "sendType", required = false, example = "")
    private String sendType;

    @ApiModelProperty(value = "发券业务单号(手工发券id)", name = "sendBusinessId", required = false, example = "")
    private Long sendBusinessId;

    @ApiModelProperty(value = "使用类型：1-线上，2-线下", name = "useType", required = false, example = "")
    private Byte useType;

    @ApiModelProperty(value = "核销门店", name = "useStoreId", required = false, example = "")
    private String useStoreId;

    @ApiModelProperty(value = "券使用业务单号", name = "useBusinessCode", required = false, example = "")
    private String useBusinessCode;

    @ApiModelProperty(value = "", name = "useBusinessAmount", required = false, example = "")
    private BigDecimal useBusinessAmount;

    @ApiModelProperty(value = "使用时间", name = "useTime", required = false, example = "")
    private Date useTime;

    @ApiModelProperty(value = "是否使用(1-已使用，0-未使用)", name = "isUse", required = false, example = "")
    private Boolean isUse;

    @ApiModelProperty(value = "5-线上绑定，10-同步中，11-同步失败，12-同步成功，20-未使用，25-已过期，30-已核销,35-已作废",
            name = "couponStatus", required = false, example = "")
    private Byte couponStatus;

    @ApiModelProperty(value = "条形码url", name = "barcodeUrl", required = false, example = "")
    private String barcodeUrl;

    @ApiModelProperty(value = "二维码url", name = "qrcodeUrl", required = false, example = "")
    private String qrcodeUrl;

    @ApiModelProperty(value = "备注", name = "remark", required = false, example = "")
    private String remark;

    @ApiModelProperty(value = "创建人id", name = "createUserId", required = false, example = "")
    private Long createUserId;

    @ApiModelProperty(value = "创建人", name = "createUserName", required = false, example = "")
    private String createUserName;

    @ApiModelProperty(value = "创建时间", name = "createDate", required = false, example = "")
    private Date createDate;

    @ApiModelProperty(value = "数据有效性（1有效，0无效）", name = "valid", required = false, example = "")
    private Boolean valid;

    @ApiModelProperty(value = "优惠类型（1现金，2折扣，3礼品）", name = "preferentialType", required = false, example = "")
    private Byte preferentialType;

    @ApiModelProperty(value = "核销来源（5-企业微信）", name = "useFrom", required = false, example = "")
    private Byte useFrom;

    @ApiModelProperty(value = "转赠状态 (0-未转赠，1-转赠中)", name = "give", required = false, example = "")
    private Boolean give;

    @ApiModelProperty(value = "核销导购", name = "staffCode", required = false, example = "")
    private String staffCode;

    @ApiModelProperty(value = "转增有奖1核销送券，0不送券", name = "transferSend", required = false, example = "")
    private Boolean transferSend;

    @ApiModelProperty(value = "转增后要发的券", name = "transferCouponDefinitionId", required = false, example = "")
    private Long transferCouponDefinitionId;

    @ApiModelProperty(value = "原来转增的会员", name = "transferMemberCode", required = false, example = "")
    private String transferMemberCode;

    @ApiModelProperty(value = "转增说明", name = "transferInfo", required = false, example = "")
    private String transferInfo;

    @ApiModelProperty(value = "员工编号", name = "astaffCode", required = false, example = "")
    private String astaffCode;

    @ApiModelProperty(value = "核销人code", name = "useMemberCode", required = false, example = "")
    private String useMemberCode;

    @ApiModelProperty(value = "发券品牌ID(异业券)", name = "sendBrandId", required = false, example = "")
    private Long sendBrandId;

    @ApiModelProperty(value = "批次号(异业券)", name = "batchNum", required = false, example = "")
    private String batchNum;

    @ApiModelProperty(value = "同步ElasticSearch最后修改时间", name = "lastEsTime", required = false, example = "")
    private Date lastEsTime;

    @ApiModelProperty(value = "发券类型（CouponSendTypeEnum 主类型）", name = "sendCouponType", required = false, example = "")
    private String sendCouponType;

    @ApiModelProperty(value = "修改时间", name = "modifiedDate", required = false, example = "")
    private Date modifiedDate;

    @ApiModelProperty(value = "手机号", name = "phone", required = false, example = "")
    private String phone;
}
