package com.bizvane.connectorservice.entity.common;

import com.bizvane.connectorservice.entity.base.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

@Data
@ToString
public class MemberOpenCardRequestVO extends BaseModel{

    @ApiModelProperty(value = "appId", name = "appId")
    private String appId;

    // 更新资料时传值
    private String erpId;
    /**
     * 微信用户的openId
     */
    private String openId;

    /**
     * 微信用户的unionId
     */
    private String unionId;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 会员姓名
     */
    private String name;

    /**
     * 等级Code
     */
    private String levelCode;

    /**
     * 等级名称
     */
    private String levelName;

    /**
     * 会员性别(1男   0女)
     */
    private Integer gender;

    /**
     * 会员生日 pattern = "yyyyMMdd"
     */
    private String birthday;

    private String offlineOrgCode;

    private String offlineOrgName;

    /**
     * 开卡门店编号
     */
    private String openStoreCode;

    /**
     * 开卡门店名称
     */
    private String openStoreName;

    /**
     * 开卡导购编号
     */
    private String openGuideCode;

    private String openGuidePhone;

    private String serviceGuideCode;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 区县
     */
    private String county;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 有效期
     */
    private String effectiveTime;

    /**
     * 开卡来源
     */
    private String source;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 开卡区别来源UR
     */
    private String registerType;

    /**
     * 所属门店UR
     */
    private String serviceStoreCode;

    /**
     * 服务门店名称
     */
    private String serviceStoreName;

    /**
     * 密码UR
     */
    private String password;

    private String taobaoNick;

    /**
     * 361备注
     */
    private  String remark;

    /**
     * 361身份证号
     */
    private String idCard;

    /**
     * 会员名称
     * */
    private String taobaoName;

    /**
     * 手机区域号
     * */
    private String phoneAreaCode;

    /**
     * 有赞openId
     * */
    private String yzOpenId;

    /**
     * 默认开卡门店
     * */
    private String defaultOpenStoreCode;

    /**
     * 默认开卡导购
     */
    private String defaultOpenGuideCode;

    /**
     * 雷朵 开卡导购名称
     */
    private String openGuideName;

    /**
     * 雷朵 标志
     * */
    private Boolean radoFlag = Boolean.FALSE;

    /**
     * 雷朵 更新时间
     * */
    private String offlineUpdateDate;

    /**
     * 会员来源渠道id
     */
    private Integer kaiKaQuDaoId;

    /**
     * 会员来源渠道描述
     */
    private String kaiKaiMiaoShuId;

    /**
     * 推荐人membercode
     */
    private String inviterMemberCode;

    private String inviterErpId;

    private String inviterPhone;
    /**
     * 推荐人会员卡号
     */
    private String inviterCardNo;

    /**
     * 推荐人会员姓名
     */
    private String inviterName;

    /**
     * 自建应用外部联系人ID
     */
    private String applicationExternalId;

    /**
     * 推荐人自建应用外部联系人ID
     */
    private String inviterApplicationExternalId;

    /**
     * 会员当前积分
     */
    private Integer integral;

    /**
     * 百胜E3线下门店从的
     */
    private String offLineShopCode;
}
