package com.bizvane.connectorservice.interfaces.zhoudasheng;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.zds.*;
import com.github.pagehelper.PageInfo;
import org.springframework.web.bind.annotation.RequestBody;

public interface ZdsService {

    /**
     * 券定义 详情 查询
     * @param couponDefinitionCode
     * @param brandId
     * @return
     */
    Result<ZdsCouponDefinition> getCouponDefinitionInfo(String couponDefinitionCode,Long brandId);

    /**
     * 券定义 列表/分页 查询
     * @param requestVo
     * @return
     */
    Result<PageInfo<ZdsCouponDefinition>> getCouponDefinitionList(CouponDefinitionListRequestVo requestVo);

    /**
     * 券实体 详情 查询
     * @param couponCode
     * @param brandId
     * @return
     */
    Result<ZdsCouponInfo> getCouponInfo(String couponCode,Long brandId);

    /**
     * 券实体 列表/分页 查询
     * @param requestVo
     * @return
     */
    Result<PageInfo<ZdsCouponInfo>> getCouponList(CouponEntityListRequestVo requestVo);

    /**
     * 会员券数量统计
     * @param erpId
     * @return
     */
    Result<CouponCountResponseVo> getCouponCountByErpId(String erpId,Long brandId);

    /**
     * 单张发券
     * @param requestVo
     * @return
     */
    Result<String> singleCoupon(SingleCouponRequestVo requestVo);

    /**
     * 批量发券
     * @param requestVo
     * @return
     */
    Result BatchCoupon(BatchCouponRequestVo requestVo);

    /**
     * 发送短信
     * @param requestVo
     * @return
     */
    Result sendSmsMessage(SmsMessageRequestVo requestVo);

    /**
     * 员工离职
     * @param requestVo
     * @return
     */
    Result guideInvalid(ZdsGuideInvalidRequestVo requestVo);

    /**
     * 店长分配会员所属关系接口
     * @param requestVo
     * @return
     */
    Result assignMembers(MemberInfoReuqestVo requestVo);

    /**
     * 小程序码生成接口
     * @param requestVo
     * @return
     */
    Result<String> generateQrCode(QrCodeRequestVo requestVo);

    /**
     * 获取周大生分享id
     * @return
     */
    Result<ZdsPostShareResponseVo> zdsPostShare(ZdsPostShareRequestVo requestVo);

    /**
     * 会员分组同步
     * @param requestVo
     * @return
     */
    Result memberGroupSync(@RequestBody ZdsMemberGroupSync requestVo);

    /**
     * 标签同步 新增
     * @param requestVo
     * @return
     */
    Result zdsAddMbrLabel(@RequestBody ZdsMbrLabelSyncRequestVo requestVo);

    /**
     * 标签同步 删除
     * @param requestVo
     * @return
     */
    Result zdsDelMbrLabel(@RequestBody ZdsMbrLabelSyncRequestVo requestVo);

    /**
     * 为邀约成功的会员打标签
     * @param requestVo
     * @return
     */
    Result memberInvitationLabel(ZdsMbrInvitationlLabelRequestVo requestVo);

    /**
     * 保存意向客户标签
     * @param requestVo
     * @return
     */
    Result addIntendedCustomerLabel(IntendedCustomerLabelVo requestVo);
}
