package com.bizvane.connectorservice.interfaces.rpc;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.req.*;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @program: connector
 * @description:
 * @author: Liu Xinpeng
 * @create: 2021-03-05 14:20
 **/
@FeignClient(value = "${feign.client.connector.name}",path = "${feign.client.connector.path}/crmSny")
public interface CrmJointServiceFeign {

    /**
     * 同步优惠券活动信息
     * @param snyCouponInfoReq
     * @return
     */
    @PostMapping("snyCouponInfo")
    Result<T> snyCouponInfo(SnyCouponInfoReq snyCouponInfoReq);

    /**
     * 同步优惠券活动信息
     * @param snyMemberCouponReq
     * @return
     */
    @PostMapping("snyMemberCoupon")
    Result<T> snyMemberCoupon(SnyMemberCouponReq snyMemberCouponReq);


    /**
     * 优惠券(全渠道)状态变更
     * @param snyCouponStatusReq
     * @return
     */
    @PostMapping("snyCouponStatus")
    Result<T> snyCouponStatus(SnyCouponStatusReq snyCouponStatusReq);


    /**
     * 优惠券转增
     * @param snyCouponTransferReq
     * @return
     */
    @PostMapping("snyCouponTransfer")
    Result<T> snyCouponTransfer(SnyCouponTransferReq snyCouponTransferReq);

    /**
     * 会员权益
     * @param snyMemberRightsReq
     * @return
     */
    @PostMapping("snyMemberRights")
    Result<T> snyMemberRights(SnyMemberRightsReq snyMemberRightsReq);
}