package com.bizvane.connectorservice.entity.common;

import com.bizvane.connectorservice.entity.base.BaseModel;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author liuying
 * @date 2018/8/14
 * @description
 */
@Data
public class OrderAddRequestVO extends BaseModel {

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 下单时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(
            value = "下单时间",
            name = "orderTime",
            required = true,
            example = "2019-12-13 11:28:12"
    )
    private Date orderTime;

    /**
     * 收货人：姓名
     */
    private String consigneeName;

    /**
     * 收货人：手机号
     */
    private String consigneePhone;

    /**
     * 收货人：省
     */
    private String consigneeProvince;

    /**
     * 收货人：市
     */
    private String consigneeCity;

    /**
     * 收货人：区
     */
    private String consigneeArea;

    /**
     * 收货人：街道
     */
    private String consigneeStreet;

    /**
     * 收货人：详细地址
     */
    private String consigneeDetailed;

    /**
     * 会员id(线下会员id)
     */
    private String erpId;

    /**
     * 会员门店id(线下门店id)
     */
    private String erpStoreId;

    /**
     * 会员门店code(线下门店code)
     */
    private String erpStoreCode;

    /**
     * 会员导购id(线下导购id)
     */
    private String erpGuideId;

    /**
     * 会员导购code(线下导购code)
     */
    private String erpGuideCode;

    /**
     * 成交金额
     */
    private BigDecimal commodityAmount;

    /**
     * 商品金额(订单总成交金额)
     */
    private BigDecimal standardAmount;

    /**与微商城协商0722 按第二种注释走
     * 标准金额(订单总标金额)
     * 优惠金额(优惠券抵扣金额)
     */
    private BigDecimal preferentialAmount;

    /**
     * 优惠金额(优惠券抵扣金额)
     * 抵扣金额(积分抵扣金额)
     */
    private BigDecimal deductibleAmount;

    /**
     * 抵扣金额(积分抵扣金额)
     * 其他优惠金额(满减  满包邮)
     */
    private BigDecimal otherPreferentialVolume;

    /**
     * 其他优惠金额(满减  满包邮)
     * 应收金额
     */
    private BigDecimal receivableAmount;

    /**
     * 应收金额
     */
    private BigDecimal transactionAmount;

    /**
     * 是否包邮(Y / N)
     */
    private String isPost;

    /**
     * 邮费
     */
    private BigDecimal postage;

    /**
     * 支付金额
     */
    private BigDecimal payMoney;

    /**
     * 券号
     */
    private String vipcouponCode;

    /**
     * 商品数组
     */
    private List<OrderItemRequestVO> orderItem;

    /**
     * 商品总数量
     */
    private Integer productCount;

    /**
     * 1.微商城订单,2.积分商城订单
     */
    private Integer orderType = 1;

    /**
     * 订单总积分
     */
    private Integer costPoints;

    /**
     * 线下会员姓名
     */
    private String vipName;

    /**
     * 线下会员卡号
     */
    private String offlineCardNo;

    /**
     * 配送方式：0：寄货到家、1：到店自提
     * 未使用
     */
    private String shippingMode;

    /**
     * 买家留言
     */
    private String userComments;

    /**
     * 商城收款方式参数
     */
   private List<PayTypesVO> payTypes;

    /**
     * 余额支付金额
     */
   private BigDecimal deductibleBalance;

    /**
     * 自提门店id
     */
   private String pickStoreId;

    /**
     * 自提门店code
     */
   private String pickStoreCode;

    /**
     * 自提门店名称
     */
   private String pickStoreName;
}
