package com.bizvane.connectorservice.interfaces.rpc;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.CouponBatchBindRequestVO;
import com.bizvane.connectorservice.entity.common.CouponBatchRequestVO;
import com.bizvane.connectorservice.entity.common.CouponBindRequestVO;
import com.bizvane.connectorservice.entity.common.CouponRequestVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author liuying
 * @date 2018/8/15
 * @description
 */

@FeignClient(value = "${feign.client.connectorcoupon.name:connectorcoupon}",path = "${feign.client.connectorcoupon.path:connectorcoupon.api}/rest")
public interface ConnectorCouponServiceFeign {

    /**
     * 批量发券
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "batchcoupon", method = RequestMethod.POST)
    Result batchcoupon(@RequestBody CouponBatchRequestVO requestVO);


    /**
     * 单张发券
     * @param requestVo
     * @return
     */
    @RequestMapping(value = "singlecoupon", method = RequestMethod.POST)
    Result singlecoupon(@RequestBody CouponRequestVO requestVo);


    /**
     * 批量线下券绑定
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "batchcouponbind", method = RequestMethod.POST)
    Result batchCouponBind(@RequestBody CouponBatchBindRequestVO requestVO);

    /**
     * 单张线下券绑定
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "singlecouponbind", method = RequestMethod.POST)
    Result singleCouponBind(@RequestBody CouponBindRequestVO requestVO);

}
